/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.quidem;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.druid.cli.QueryJettyServerInitializer;
import org.apache.druid.client.BrokerSegmentWatcherConfig;
import org.apache.druid.client.DirectDruidClientFactory;
import org.apache.druid.client.InternalQueryConfig;
import org.apache.druid.client.QueryableDruidServer;
import org.apache.druid.client.selector.CustomTierSelectorStrategyConfig;
import org.apache.druid.client.selector.ServerSelectorStrategy;
import org.apache.druid.client.selector.TierSelectorStrategy;
import org.apache.druid.curator.CuratorModule;
import org.apache.druid.curator.discovery.DiscoveryModule;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.guice.AnnouncerModule;
import org.apache.druid.guice.BrokerServiceModule;
import org.apache.druid.guice.CoordinatorDiscoveryModule;
import org.apache.druid.guice.ExpressionModule;
import org.apache.druid.guice.ExtensionsModule;
import org.apache.druid.guice.JacksonConfigManagerModule;
import org.apache.druid.guice.JavaScriptModule;
import org.apache.druid.guice.Jerseys;
import org.apache.druid.guice.JoinableFactoryModule;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.LocalDataStorageDruidModule;
import org.apache.druid.guice.MetadataConfigModule;
import org.apache.druid.guice.SegmentWranglerModule;
import org.apache.druid.guice.ServerViewModule;
import org.apache.druid.guice.StartupLoggingModule;
import org.apache.druid.guice.annotations.Client;
import org.apache.druid.guice.annotations.EscalatedClient;
import org.apache.druid.guice.http.HttpClientModule;
import org.apache.druid.guice.security.AuthenticatorModule;
import org.apache.druid.guice.security.AuthorizerModule;
import org.apache.druid.guice.security.DruidAuthModule;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.initialization.Log4jShutterDownerModule;
import org.apache.druid.initialization.ServerInjectorBuilder;
import org.apache.druid.initialization.TombstoneDataStorageModule;
import org.apache.druid.metadata.storage.derby.DerbyMetadataStorageDruidModule;
import org.apache.druid.query.RetryQueryRunnerConfig;
import org.apache.druid.quidem.QuidemCaptureModule;
import org.apache.druid.rpc.guice.ServiceClientModule;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumModule;
import org.apache.druid.server.BrokerQueryResource;
import org.apache.druid.server.ClientInfoResource;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.http.BrokerResource;
import org.apache.druid.server.http.SelfDiscoveryResource;
import org.apache.druid.server.initialization.ExternalStorageAccessSecurityModule;
import org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.apache.druid.server.initialization.jetty.JettyServerModule;
import org.apache.druid.server.metrics.QueryCountStatsProvider;
import org.apache.druid.server.metrics.SubqueryCountStatsProvider;
import org.apache.druid.server.security.TLSCertificateCheckerModule;
import org.apache.druid.sql.calcite.schema.BrokerSegmentMetadataCache;
import org.apache.druid.sql.calcite.schema.DruidSchemaName;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.calcite.util.DruidModuleCollection;
import org.apache.druid.sql.calcite.util.SqlTestFramework;
import org.apache.druid.storage.StorageConnectorModule;
import org.apache.druid.timeline.PruneLoadSpec;
import org.eclipse.jetty.server.Server;

public class ExposedAsBrokerQueryComponentSupplierWrapper
extends SqlTestFramework.QueryComponentSupplierDelegate {
    public ExposedAsBrokerQueryComponentSupplierWrapper(SqlTestFramework.QueryComponentSupplier delegate) {
        super(delegate);
    }

    public void gatherProperties(Properties properties) {
        properties.put("druid.enableTlsPort", "false");
        properties.put("druid.zk.service.enabled", "false");
        properties.put("druid.plaintextPort", "12345");
        properties.put("druid.host", "localhost");
        properties.put("druid.broker.segment.awaitInitializationOnStart", "false");
    }

    public DruidModule getCoreModule() {
        ImmutableList.Builder modules = ImmutableList.builder();
        modules.add((Object)super.getCoreModule());
        modules.addAll(this.forServerModules());
        modules.addAll(ExposedAsBrokerQueryComponentSupplierWrapper.brokerModules());
        modules.add((Object)new QuidemCaptureModule());
        return DruidModuleCollection.of((List)modules.build());
    }

    public DruidModule getOverrideModule() {
        return DruidModuleCollection.of((Module[])new Module[]{super.getOverrideModule(), new BrokerTestModule()});
    }

    private List<Module> forServerModules() {
        return ImmutableList.of((Object)new Log4jShutterDownerModule(), (Object)new ExtensionsModule.SecondaryModule(), (Object)new DruidAuthModule(), (Object)new TLSCertificateCheckerModule(), (Object)HttpClientModule.global(), (Object)HttpClientModule.escalatedGlobal(), (Object)new HttpClientModule("druid.broker.http", Client.class, true), (Object)new HttpClientModule("druid.broker.http", EscalatedClient.class, true), (Object)new CuratorModule(), (Object)new AnnouncerModule(), (Object)new SegmentWriteOutMediumModule(), (Object)new JettyServerModule(), (Object[])new Module[]{new ExpressionModule(), new DiscoveryModule(), new ServerViewModule(), new MetadataConfigModule(), new DerbyMetadataStorageDruidModule(), new JacksonConfigManagerModule(), new CoordinatorDiscoveryModule(), new LocalDataStorageDruidModule(), new TombstoneDataStorageModule(), new JavaScriptModule(), new AuthenticatorModule(), new AuthorizerModule(), new StartupLoggingModule(), new ExternalStorageAccessSecurityModule(), new ServiceClientModule(), new StorageConnectorModule(), ServerInjectorBuilder.registerNodeRoleModule((Set)ImmutableSet.of())});
    }

    static List<? extends Module> brokerModules() {
        return ImmutableList.of((Object)new SegmentWranglerModule(), (Object)new JoinableFactoryModule(), (Object)new BrokerServiceModule(), binder -> {
            binder.bind(QueryableDruidServer.Maker.class).to(DirectDruidClientFactory.class).in(LazySingleton.class);
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/broker");
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(8082);
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(8282);
            binder.bindConstant().annotatedWith(PruneLoadSpec.class).to(true);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.broker.select", TierSelectorStrategy.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.broker.select.tier.custom", CustomTierSelectorStrategyConfig.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.broker.balancer", ServerSelectorStrategy.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.broker.retryPolicy", RetryQueryRunnerConfig.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.broker.segment", BrokerSegmentWatcherConfig.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.broker.internal.query.config", InternalQueryConfig.class);
            binder.bind(JettyServerInitializer.class).to(QueryJettyServerInitializer.class).in(LazySingleton.class);
            binder.bind(BrokerQueryResource.class).in(LazySingleton.class);
            Jerseys.addResource((Binder)binder, BrokerQueryResource.class);
            binder.bind(QueryCountStatsProvider.class).to(BrokerQueryResource.class).in(LazySingleton.class);
            binder.bind(SubqueryCountStatsProvider.class).toInstance((Object)new SubqueryCountStatsProvider());
            Jerseys.addResource((Binder)binder, BrokerResource.class);
            Jerseys.addResource((Binder)binder, ClientInfoResource.class);
            LifecycleModule.register((Binder)binder, BrokerQueryResource.class);
            LifecycleModule.register((Binder)binder, Server.class);
            binder.bind(String.class).annotatedWith(DruidSchemaName.class).toInstance((Object)"druid");
            Jerseys.addResource((Binder)binder, SelfDiscoveryResource.class);
            LifecycleModule.registerKey((Binder)binder, (Key)Key.get(SelfDiscoveryResource.class));
        });
    }

    public static class BrokerTestModule
    extends AbstractModule {
        protected void configure() {
        }

        @Provides
        @LazySingleton
        public BrokerSegmentMetadataCache provideCache() {
            return null;
        }

        @Provides
        @LazySingleton
        DruidNodeDiscoveryProvider getDruidNodeDiscoveryProvider() {
            DruidNode coordinatorNode = CalciteTests.mockCoordinatorNode();
            return CalciteTests.mockDruidNodeDiscoveryProvider((DruidNode)coordinatorNode);
        }
    }
}

