/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import java.util.HashMap;
import java.util.Map;
import org.apache.druid.segment.incremental.InputRowFilterResult;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.incremental.RowIngestionMetersTotals;

public class SimpleRowIngestionMeters
implements RowIngestionMeters {
    private long processed;
    private long processedWithError;
    private long unparseable;
    private long processedBytes;
    private final long[] thrownAwayByReason = new long[InputRowFilterResult.numValues()];

    @Override
    public long getProcessed() {
        return this.processed;
    }

    @Override
    public void incrementProcessed() {
        ++this.processed;
    }

    @Override
    public void incrementProcessedBytes(long increment) {
        this.processedBytes += increment;
    }

    @Override
    public long getProcessedBytes() {
        return this.processedBytes;
    }

    @Override
    public long getProcessedWithError() {
        return this.processedWithError;
    }

    @Override
    public void incrementProcessedWithError() {
        ++this.processedWithError;
    }

    @Override
    public long getUnparseable() {
        return this.unparseable;
    }

    @Override
    public void incrementUnparseable() {
        ++this.unparseable;
    }

    @Override
    public long getThrownAway() {
        long total = 0L;
        for (InputRowFilterResult reason : InputRowFilterResult.rejectedValues()) {
            total += this.thrownAwayByReason[reason.ordinal()];
        }
        return total;
    }

    @Override
    public void incrementThrownAway(InputRowFilterResult reason) {
        int n = reason.ordinal();
        this.thrownAwayByReason[n] = this.thrownAwayByReason[n] + 1L;
    }

    @Override
    public Map<String, Long> getThrownAwayByReason() {
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (InputRowFilterResult reason : InputRowFilterResult.rejectedValues()) {
            long count = this.thrownAwayByReason[reason.ordinal()];
            if (count <= 0L) continue;
            result.put(reason.getReason(), count);
        }
        return result;
    }

    @Override
    public RowIngestionMetersTotals getTotals() {
        return new RowIngestionMetersTotals(this.processed, this.processedBytes, this.processedWithError, this.getThrownAwayByReason(), this.unparseable);
    }

    @Override
    public Map<String, Object> getMovingAverages() {
        throw new UnsupportedOperationException();
    }

    public void addRowIngestionMetersTotals(RowIngestionMetersTotals rowIngestionMetersTotals) {
        this.processed += rowIngestionMetersTotals.getProcessed();
        this.processedWithError += rowIngestionMetersTotals.getProcessedWithError();
        this.unparseable += rowIngestionMetersTotals.getUnparseable();
        this.processedBytes += rowIngestionMetersTotals.getProcessedBytes();
        Map<String, Long> thrownAwayByReason = rowIngestionMetersTotals.getThrownAwayByReason();
        for (InputRowFilterResult reason : InputRowFilterResult.rejectedValues()) {
            int n = reason.ordinal();
            this.thrownAwayByReason[n] = this.thrownAwayByReason[n] + thrownAwayByReason.getOrDefault(reason.getReason(), 0L);
        }
    }
}

