/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ConciseBitmapFactory;
import org.apache.druid.collections.bitmap.RoaringBitmapFactory;
import org.apache.druid.error.DruidException;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.ConciseBitmapSerdeFactory;
import org.apache.druid.segment.data.RoaringBitmapSerdeFactory;

public class BitmapSerde {
    public static BitmapSerdeFactory createLegacyFactory() {
        return new LegacyBitmapSerdeFactory();
    }

    public static BitmapSerdeFactory forBitmapFactory(BitmapFactory factory) {
        if (factory instanceof RoaringBitmapFactory) {
            return new DefaultBitmapSerdeFactory();
        }
        if (factory instanceof ConciseBitmapFactory) {
            return new ConciseBitmapSerdeFactory();
        }
        throw DruidException.defensive("Unknown type of bitmapFactory [%s]", factory.getClass());
    }

    @JsonTypeName(value="concise")
    public static class LegacyBitmapSerdeFactory
    extends ConciseBitmapSerdeFactory {
    }

    @JsonTypeName(value="roaring")
    public static class DefaultBitmapSerdeFactory
    extends RoaringBitmapSerdeFactory {
        public DefaultBitmapSerdeFactory() {
            super(RoaringBitmapFactory.INSTANCE);
        }
    }
}

