/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.primitives.SignedBytes;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.java.util.common.StringUtils;

public enum StringEncoding implements Cacheable
{
    UTF8,
    UTF16LE;


    @JsonCreator
    public static StringEncoding fromString(String name) {
        return StringEncoding.valueOf(StringUtils.toUpperCase(name));
    }

    @Override
    public byte[] getCacheKey() {
        return new byte[]{SignedBytes.checkedCast((long)this.ordinal())};
    }

    @JsonValue
    public String toString() {
        return StringUtils.toLowerCase(this.name());
    }
}

