/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.RangeSet;
import java.util.List;
import java.util.Map;
import org.apache.druid.timeline.partition.LinearPartitionChunk;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecLookup;

public final class LinearShardSpec
implements ShardSpec {
    private final int partitionNum;

    @JsonCreator
    public LinearShardSpec(@JsonProperty(value="partitionNum") Integer partitionNum) {
        this.partitionNum = (Integer)Preconditions.checkNotNull((Object)partitionNum, (Object)"Must set partitionNum on LinearShardSpec");
    }

    @Override
    @JsonProperty(value="partitionNum")
    public int getPartitionNum() {
        return this.partitionNum;
    }

    @Override
    public int getNumCorePartitions() {
        return 0;
    }

    @Override
    public ShardSpecLookup getLookup(List<? extends ShardSpec> shardSpecs) {
        return (timestamp, row) -> (ShardSpec)shardSpecs.get(0);
    }

    @Override
    public List<String> getDomainDimensions() {
        return ImmutableList.of();
    }

    @Override
    public boolean possibleInDomain(Map<String, RangeSet<String>> domain) {
        return true;
    }

    @Override
    public <T> PartitionChunk<T> createChunk(T obj) {
        return new LinearPartitionChunk<T>(this.partitionNum, obj);
    }

    @Override
    public String getType() {
        return "linear";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LinearShardSpec)) {
            return false;
        }
        LinearShardSpec that = (LinearShardSpec)o;
        return this.partitionNum == that.partitionNum;
    }

    public int hashCode() {
        return this.partitionNum;
    }

    public String toString() {
        return "LinearShardSpec{partitionNum=" + this.partitionNum + "}";
    }
}

