/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import javax.annotation.Nullable;
import org.apache.druid.annotations.SubclassesMustOverrideEqualsAndHashCode;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;

@SubclassesMustOverrideEqualsAndHashCode
public interface DruidPredicateFactory {
    public DruidObjectPredicate<String> makeStringPredicate();

    public DruidLongPredicate makeLongPredicate();

    public DruidFloatPredicate makeFloatPredicate();

    public DruidDoublePredicate makeDoublePredicate();

    default public DruidObjectPredicate<Object[]> makeArrayPredicate(@Nullable TypeSignature<ValueType> inputType) {
        throw new UOE("Predicate does not support ARRAY types", new Object[0]);
    }

    default public DruidObjectPredicate<Object> makeObjectPredicate() {
        DruidObjectPredicate<String> stringPredicate = this.makeStringPredicate();
        return o -> stringPredicate.apply(null);
    }
}

