/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.MemoryAllocatorFactory;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.frame.write.RowBasedFrameWriterFactory;
import org.apache.druid.frame.write.columnar.ColumnarFrameWriterFactory;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;

public class FrameWriters {
    private FrameWriters() {
    }

    public static FrameWriterFactory makeFrameWriterFactory(FrameType frameType, MemoryAllocatorFactory allocatorFactory, RowSignature signature, List<KeyColumn> sortColumns, boolean removeNullBytes) {
        if (frameType.isRowBased()) {
            return new RowBasedFrameWriterFactory(allocatorFactory, frameType, signature, sortColumns, removeNullBytes);
        }
        if (removeNullBytes) {
            throw DruidException.defensive("Cannot use removeNullBytes with frameType[%s]", new Object[]{frameType});
        }
        return new ColumnarFrameWriterFactory(allocatorFactory, signature, sortColumns);
    }

    public static FrameWriterFactory makeColumnBasedFrameWriterFactory(MemoryAllocatorFactory allocatorFactory, RowSignature signature, List<KeyColumn> sortColumns) {
        return new ColumnarFrameWriterFactory(allocatorFactory, signature, sortColumns);
    }

    public static RowSignature sortableSignature(RowSignature signature, List<KeyColumn> keyColumns) {
        RowSignature.Builder builder = RowSignature.builder();
        for (KeyColumn columnName : keyColumns) {
            Optional<ColumnType> columnType = signature.getColumnType(columnName.columnName());
            if (!columnType.isPresent()) {
                throw new IAE("Column [%s] not present in signature", columnName);
            }
            builder.add(columnName.columnName(), columnType.get());
        }
        Set sortColumnNames = keyColumns.stream().map(KeyColumn::columnName).collect(Collectors.toSet());
        for (int i = 0; i < signature.size(); ++i) {
            String columnName = signature.getColumnName(i);
            if (sortColumnNames.contains(columnName)) continue;
            builder.add(columnName, signature.getColumnType(i).orElse(null));
        }
        return builder.build();
    }
}

