/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.ExpressionLambdaAggregatorFactory;
import org.apache.druid.query.aggregation.ExpressionLambdaAggregatorInputBindings;

public class ExpressionLambdaAggregator
implements Aggregator {
    private final Expr lambda;
    private final List<String> inputColumns;
    private final ExpressionLambdaAggregatorInputBindings bindings;
    private final int maxSizeBytes;
    private final boolean aggregateNullInputs;
    private boolean hasValue;

    public ExpressionLambdaAggregator(ExpressionLambdaAggregatorFactory.FactorizePlan thePlan, int maxSizeBytes) {
        this.lambda = thePlan.getExpression();
        this.bindings = thePlan.getBindings();
        this.hasValue = !thePlan.isNullUnlessAggregated();
        this.aggregateNullInputs = thePlan.shouldAggregateNullInputs();
        this.inputColumns = thePlan.getInputs();
        this.maxSizeBytes = maxSizeBytes;
    }

    @Override
    public void aggregate() {
        ExprEval eval;
        int estimatedSize;
        if (!this.aggregateNullInputs) {
            for (String column : this.inputColumns) {
                if (this.bindings.get(column) != null) continue;
                return;
            }
        }
        if ((estimatedSize = (eval = this.lambda.eval(this.bindings)).type().getNullableStrategy().estimateSizeBytes(eval.value())) > this.maxSizeBytes) {
            throw new ISE("Exceeded memory usage when aggregating type [%s], size [%s] is larger than max [%s]", eval.type().asTypeString(), estimatedSize, this.maxSizeBytes);
        }
        this.bindings.accumulate(eval);
        this.hasValue = true;
    }

    @Override
    @Nullable
    public Object get() {
        return this.hasValue ? this.bindings.getAccumulator().value() : null;
    }

    @Override
    public float getFloat() {
        return (float)this.bindings.getAccumulator().asDouble();
    }

    @Override
    public long getLong() {
        return this.bindings.getAccumulator().asLong();
    }

    @Override
    public double getDouble() {
        return this.bindings.getAccumulator().asDouble();
    }

    @Override
    public boolean isNull() {
        return this.bindings.getAccumulator().isNumericNull();
    }

    @Override
    public void close() {
    }
}

