/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.audit;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.audit.RequestInfo;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.DateTimes;
import org.joda.time.DateTime;

public class AuditEntry {
    private final String key;
    private final String type;
    private final AuditInfo auditInfo;
    private final RequestInfo request;
    private final Payload payload;
    private final DateTime auditTime;

    @JsonCreator
    public AuditEntry(@JsonProperty(value="key") String key, @JsonProperty(value="type") String type, @JsonProperty(value="auditInfo") AuditInfo authorInfo, @JsonProperty(value="request") RequestInfo request, @JsonProperty(value="payload") Payload payload, @JsonProperty(value="auditTime") DateTime auditTime) {
        Preconditions.checkNotNull((Object)key, (Object)"key cannot be null");
        Preconditions.checkNotNull((Object)type, (Object)"type cannot be null");
        Preconditions.checkNotNull((Object)authorInfo, (Object)"author cannot be null");
        this.key = key;
        this.type = type;
        this.auditInfo = authorInfo;
        this.request = request;
        this.auditTime = auditTime == null ? DateTimes.nowUtc() : auditTime;
        this.payload = payload == null ? Payload.fromString("") : payload;
    }

    @JsonProperty
    public String getKey() {
        return this.key;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    @JsonProperty
    public AuditInfo getAuditInfo() {
        return this.auditInfo;
    }

    @JsonProperty
    public RequestInfo getRequest() {
        return this.request;
    }

    @JsonProperty
    public Payload getPayload() {
        return this.payload;
    }

    @JsonProperty
    public DateTime getAuditTime() {
        return this.auditTime;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditEntry that = (AuditEntry)o;
        return Objects.equals(this.auditTime, that.auditTime) && Objects.equals(this.key, that.key) && Objects.equals(this.type, that.type) && Objects.equals(this.auditInfo, that.auditInfo) && Objects.equals(this.request, that.request) && Objects.equals(this.payload, that.payload);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.type, this.auditInfo, this.request, this.payload, this.auditTime);
    }

    public static class Payload {
        private final String serialized;
        private final Object raw;

        @JsonCreator
        public static Payload fromString(String serialized) {
            return new Payload(serialized, null);
        }

        @JsonValue
        public String toString() {
            return this.serialized == null ? "" : this.serialized;
        }

        private Payload(String serialized, Object raw) {
            this.serialized = serialized;
            this.raw = raw;
        }

        public String serialized() {
            return this.serialized;
        }

        public Object raw() {
            return this.raw;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Payload that = (Payload)o;
            return Objects.equals(this.serialized, that.serialized) && Objects.equals(this.raw, that.raw);
        }

        public int hashCode() {
            return Objects.hash(this.serialized, this.raw);
        }
    }

    public static class Builder {
        private String key;
        private String type;
        private AuditInfo auditInfo;
        private RequestInfo requestInfo;
        private Object payload;
        private String serializedPayload;
        private DateTime auditTime = DateTimes.nowUtc();

        private Builder() {
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder auditInfo(AuditInfo auditInfo) {
            this.auditInfo = auditInfo;
            return this;
        }

        public Builder request(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        public Builder serializedPayload(String serializedPayload) {
            this.serializedPayload = serializedPayload;
            return this;
        }

        public Builder payload(Object payload) {
            this.payload = payload;
            return this;
        }

        public Builder auditTime(DateTime auditTime) {
            this.auditTime = auditTime;
            return this;
        }

        public AuditEntry build() {
            if (this.payload != null && this.serializedPayload != null) {
                throw DruidException.defensive("Either payload[%s] or serializedPayload[%s] must be specified, not both.", this.payload, this.serializedPayload);
            }
            return new AuditEntry(this.key, this.type, this.auditInfo, this.requestInfo, new Payload(this.serializedPayload, this.payload), this.auditTime);
        }
    }
}

