/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.join.HashJoinEngine;
import org.apache.druid.segment.join.JoinPrefixUtils;
import org.apache.druid.segment.join.JoinableClause;
import org.apache.druid.segment.join.PostJoinCursor;
import org.apache.druid.segment.join.filter.JoinFilterAnalyzer;
import org.apache.druid.segment.join.filter.JoinFilterPreAnalysis;
import org.apache.druid.segment.join.filter.JoinFilterPreAnalysisKey;
import org.apache.druid.segment.join.filter.JoinFilterSplit;
import org.apache.druid.utils.CloseableUtils;

public class HashJoinSegmentCursorFactory
implements CursorFactory {
    private final CursorFactory baseCursorFactory;
    @Nullable
    private final Filter baseFilter;
    private final List<JoinableClause> clauses;
    private final JoinFilterPreAnalysis joinFilterPreAnalysis;

    public HashJoinSegmentCursorFactory(CursorFactory baseCursorFactory, @Nullable Filter baseFilter, List<JoinableClause> clauses, JoinFilterPreAnalysis joinFilterPreAnalysis) {
        this.baseCursorFactory = baseCursorFactory;
        this.baseFilter = baseFilter;
        this.clauses = clauses;
        this.joinFilterPreAnalysis = joinFilterPreAnalysis;
    }

    @Override
    public CursorHolder makeCursorHolder(final CursorBuildSpec spec) {
        HashSet<String> physicalColumns;
        final CursorBuildSpec.CursorBuildSpecBuilder cursorBuildSpecBuilder = CursorBuildSpec.builder(spec).setFilter(null);
        final Filter combinedFilter = this.baseFilterAnd(spec.getFilter());
        HashSet<String> hashSet = physicalColumns = spec.getPhysicalColumns() != null ? new HashSet<String>(spec.getPhysicalColumns()) : null;
        if (physicalColumns != null && combinedFilter != null) {
            for (String column : combinedFilter.getRequiredColumns()) {
                if (spec.getVirtualColumns().exists(column)) continue;
                physicalColumns.add(column);
            }
        }
        if (this.clauses.isEmpty()) {
            CursorBuildSpec newSpec = cursorBuildSpecBuilder.setFilter(combinedFilter).setPhysicalColumns(physicalColumns).build();
            return this.baseCursorFactory.makeCursorHolder(newSpec);
        }
        return new CursorHolder(){
            final Closer joinablesCloser = Closer.create();
            final JoinFilterPreAnalysis actualPreAnalysis;
            final JoinFilterSplit joinFilterSplit;
            final CursorHolder baseCursorHolder;
            {
                JoinFilterPreAnalysisKey keyIn = new JoinFilterPreAnalysisKey(HashJoinSegmentCursorFactory.this.joinFilterPreAnalysis.getKey().getRewriteConfig(), HashJoinSegmentCursorFactory.this.clauses, spec.getVirtualColumns(), combinedFilter);
                JoinFilterPreAnalysisKey keyCached = HashJoinSegmentCursorFactory.this.joinFilterPreAnalysis.getKey();
                this.actualPreAnalysis = keyIn.equals(keyCached) ? HashJoinSegmentCursorFactory.this.joinFilterPreAnalysis : JoinFilterAnalyzer.computeJoinFilterPreAnalysis(keyIn);
                this.joinFilterSplit = JoinFilterAnalyzer.splitFilter(this.actualPreAnalysis, HashJoinSegmentCursorFactory.this.baseFilter);
                if (this.joinFilterSplit.getBaseTableFilter().isPresent()) {
                    cursorBuildSpecBuilder.setFilter(this.joinFilterSplit.getBaseTableFilter().get());
                }
                VirtualColumns preJoinVirtualColumns = VirtualColumns.fromIterable(Iterables.concat((Iterable)Sets.difference((Set)ImmutableSet.copyOf((Object[])spec.getVirtualColumns().getVirtualColumns()), HashJoinSegmentCursorFactory.this.joinFilterPreAnalysis.getPostJoinVirtualColumns()), this.joinFilterSplit.getPushDownVirtualColumns()));
                cursorBuildSpecBuilder.setVirtualColumns(preJoinVirtualColumns);
                if (physicalColumns != null) {
                    if (this.joinFilterSplit.getBaseTableFilter().isPresent()) {
                        for (String column : this.joinFilterSplit.getBaseTableFilter().get().getRequiredColumns()) {
                            if (spec.getVirtualColumns().exists(column) || preJoinVirtualColumns.exists(column)) continue;
                            physicalColumns.add(column);
                        }
                    }
                    for (VirtualColumn virtualColumn : preJoinVirtualColumns.getVirtualColumns()) {
                        for (String column : virtualColumn.requiredColumns()) {
                            if (spec.getVirtualColumns().exists(column) || preJoinVirtualColumns.exists(column)) continue;
                            physicalColumns.add(column);
                        }
                    }
                    HashSet<String> prefixes = new HashSet<String>();
                    for (JoinableClause clause : HashJoinSegmentCursorFactory.this.clauses) {
                        prefixes.add(clause.getPrefix());
                        physicalColumns.addAll(clause.getCondition().getRequiredColumns());
                    }
                    for (String prefix : prefixes) {
                        physicalColumns.removeIf(x -> JoinPrefixUtils.isPrefixedBy(x, prefix));
                    }
                    cursorBuildSpecBuilder.setPhysicalColumns(physicalColumns);
                }
                this.baseCursorHolder = this.joinablesCloser.register(HashJoinSegmentCursorFactory.this.baseCursorFactory.makeCursorHolder(cursorBuildSpecBuilder.build()));
            }

            @Override
            public Cursor asCursor() {
                Cursor baseCursor = this.baseCursorHolder.asCursor();
                if (baseCursor == null) {
                    return null;
                }
                Cursor retVal = baseCursor;
                for (JoinableClause clause : HashJoinSegmentCursorFactory.this.clauses) {
                    retVal = HashJoinEngine.makeJoinCursor(retVal, clause, this.joinablesCloser);
                }
                return PostJoinCursor.wrap(retVal, VirtualColumns.fromIterable(this.actualPreAnalysis.getPostJoinVirtualColumns()), this.joinFilterSplit.getJoinTableFilter().orElse(null));
            }

            @Override
            public List<OrderBy> getOrdering() {
                return HashJoinSegmentCursorFactory.this.computeOrdering(this.baseCursorHolder.getOrdering());
            }

            @Override
            public void close() {
                CloseableUtils.closeAndWrapExceptions(this.joinablesCloser);
            }
        };
    }

    @Override
    public RowSignature getRowSignature() {
        RowSignature baseSignature = this.baseCursorFactory.getRowSignature();
        LinkedHashSet<String> columns = new LinkedHashSet<String>(baseSignature.getColumnNames());
        for (JoinableClause clause : this.clauses) {
            columns.addAll(clause.getAvailableColumnsPrefixed());
        }
        RowSignature.Builder builder = RowSignature.builder();
        LinkedHashSet reverseClauses = new LinkedHashSet(Lists.reverse(this.clauses));
        for (String column : columns) {
            Optional<JoinableClause> maybeClause = reverseClauses.stream().filter(c -> c.includesColumn(column)).findFirst();
            if (maybeClause.isPresent()) {
                JoinableClause clause = maybeClause.get();
                builder.add(column, ColumnType.fromCapabilities(clause.getJoinable().getColumnCapabilities(clause.unprefix(column))));
                continue;
            }
            builder.add(column, baseSignature.getColumnType(column).get());
        }
        return builder.build();
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        Optional<JoinableClause> maybeClause = Lists.reverse(this.clauses).stream().filter(x -> x.includesColumn(column)).findFirst();
        if (maybeClause.isPresent()) {
            JoinableClause clause = maybeClause.get();
            return clause.getJoinable().getColumnCapabilities(clause.unprefix(column));
        }
        return this.baseCursorFactory.getColumnCapabilities(column);
    }

    @Nullable
    private Filter baseFilterAnd(@Nullable Filter other) {
        return Filters.maybeAnd(Arrays.asList(this.baseFilter, other)).orElse(null);
    }

    private List<OrderBy> computeOrdering(List<OrderBy> baseOrdering) {
        int limit;
        for (limit = 0; limit < baseOrdering.size() && this.baseCursorFactory.getRowSignature().contains(baseOrdering.get(limit).getColumnName()); ++limit) {
        }
        return limit == baseOrdering.size() ? baseOrdering : baseOrdering.subList(0, limit);
    }
}

