/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.generator;

import java.util.Collections;
import java.util.List;
import org.apache.commons.math3.distribution.EnumeratedDistribution;
import org.apache.commons.math3.util.Pair;

public class SequentialDistribution
extends EnumeratedDistribution {
    private Integer start;
    private Integer end;
    private List<Object> enumeratedValues;
    private int counter;

    public SequentialDistribution(Integer start, Integer end, List<Object> enumeratedValues) {
        super(Collections.singletonList(new Pair(null, (Object)1.0)));
        this.start = start;
        this.end = end;
        this.enumeratedValues = enumeratedValues;
        this.counter = enumeratedValues == null ? start : 0;
    }

    public Object sample() {
        Object ret;
        if (this.enumeratedValues != null) {
            ret = this.enumeratedValues.get(this.counter);
            this.counter = (this.counter + 1) % this.enumeratedValues.size();
        } else {
            ret = this.counter;
            ++this.counter;
            if (this.counter >= this.end) {
                this.counter = this.start;
            }
        }
        return ret;
    }
}

