/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.any;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.any.NumericAnyBufferAggregator;
import org.apache.druid.segment.BaseFloatColumnValueSelector;

public class FloatAnyBufferAggregator
extends NumericAnyBufferAggregator<BaseFloatColumnValueSelector> {
    public FloatAnyBufferAggregator(BaseFloatColumnValueSelector valueSelector) {
        super(valueSelector);
    }

    @Override
    void initValue(ByteBuffer buf, int position) {
        buf.putFloat(position + 1, 0.0f);
    }

    @Override
    void putValue(ByteBuffer buf, int position) {
        buf.putFloat(position + 1, ((BaseFloatColumnValueSelector)this.valueSelector).getFloat());
    }

    @Override
    @Nullable
    public Object get(ByteBuffer buf, int position) {
        boolean isNull = this.isValueNull(buf, position);
        return isNull ? null : Float.valueOf(buf.getFloat(position + 1));
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        return buf.getFloat(position + 1);
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        return (long)buf.getFloat(position + 1);
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        return buf.getFloat(position + 1);
    }
}

