/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer.report;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.apache.druid.indexer.report.IngestionStatsAndErrorsTaskReport;
import org.apache.druid.indexer.report.KillTaskReport;
import org.apache.druid.indexer.report.TaskContextReport;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="ingestionStatsAndErrors", value=IngestionStatsAndErrorsTaskReport.class), @JsonSubTypes.Type(name="killUnusedSegments", value=KillTaskReport.class), @JsonSubTypes.Type(name="taskContext", value=TaskContextReport.class)})
public interface TaskReport {
    public String getTaskId();

    public String getReportKey();

    public Object getPayload();

    public static ReportMap buildTaskReports(TaskReport ... taskReports) {
        ReportMap taskReportMap = new ReportMap();
        for (TaskReport taskReport : taskReports) {
            taskReportMap.put(taskReport.getReportKey(), taskReport);
        }
        return taskReportMap;
    }

    public static class ReportMap
    extends LinkedHashMap<String, TaskReport> {
        public <T extends TaskReport> Optional<T> findReport(String reportKey) {
            return Optional.ofNullable((TaskReport)this.get(reportKey));
        }
    }
}

