/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write;

import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.column.ColumnType;

public class UnsupportedColumnTypeException
extends RuntimeException {
    private final String columnName;
    @Nullable
    private final ColumnType columnType;

    public UnsupportedColumnTypeException(String columnName, @Nullable ColumnType columnType) {
        super(UnsupportedColumnTypeException.message(columnName, columnType));
        this.columnName = columnName;
        this.columnType = columnType;
    }

    public static String message(String columnName, @Nullable ColumnType columnType) {
        return columnType == null ? StringUtils.format("Cannot handle column [%s] with unknown type", columnName) : StringUtils.format("Cannot handle column [%s] with type [%s]", columnName, columnType);
    }

    public String getColumnName() {
        return this.columnName;
    }

    @Nullable
    public ColumnType getColumnType() {
        return this.columnType;
    }
}

