/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.parsers.JavaScriptParser;
import org.apache.druid.java.util.common.parsers.Parser;
import org.apache.druid.js.JavaScriptConfig;

public class JavaScriptParseSpec
extends ParseSpec {
    private final String function;
    private final JavaScriptConfig config;
    private JavaScriptParser parser;

    @JsonCreator
    public JavaScriptParseSpec(@JsonProperty(value="timestampSpec") TimestampSpec timestampSpec, @JsonProperty(value="dimensionsSpec") DimensionsSpec dimensionsSpec, @JsonProperty(value="function") String function, @JacksonInject JavaScriptConfig config) {
        super(timestampSpec, dimensionsSpec);
        this.function = function;
        this.config = config;
    }

    @JsonProperty(value="function")
    public String getFunction() {
        return this.function;
    }

    @Override
    public Parser<String, Object> makeParser() {
        Preconditions.checkState((boolean)this.config.isEnabled(), (Object)"JavaScript is disabled");
        this.parser = this.parser == null ? new JavaScriptParser(this.function) : this.parser;
        return this.parser;
    }

    @Override
    public ParseSpec withTimestampSpec(TimestampSpec spec) {
        return new JavaScriptParseSpec(spec, this.getDimensionsSpec(), this.function, this.config);
    }

    @Override
    public ParseSpec withDimensionsSpec(DimensionsSpec spec) {
        return new JavaScriptParseSpec(this.getTimestampSpec(), spec, this.function, this.config);
    }
}

