/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.IntegrationTestingConfigProvider;

public class DockerConfigProvider
implements IntegrationTestingConfigProvider {
    @JsonProperty
    @NotNull
    private String dockerIp;
    @JsonProperty
    private String extraDatasourceNameSuffix = "";
    @JsonProperty
    private String cloudPath;
    @JsonProperty
    private String cloudBucket;
    @JsonProperty
    private String cloudRegion;
    @JsonProperty
    private String s3AssumeRoleWithExternalId;
    @JsonProperty
    private String s3AssumeRoleExternalId;
    @JsonProperty
    private String s3AssumeRoleWithoutExternalId;
    @JsonProperty
    private String hadoopGcsCredentialsPath;
    @JsonProperty
    private String azureKey;
    @JsonProperty
    private String streamEndpoint;
    @JsonProperty
    @JsonDeserialize(using=ArbitraryPropertiesJsonDeserializer.class)
    private Map<String, String> properties = new HashMap<String, String>();

    public IntegrationTestingConfig get() {
        return new IntegrationTestingConfig(){

            @Override
            public String getCoordinatorUrl() {
                return "http://" + DockerConfigProvider.this.dockerIp + ":8081";
            }

            @Override
            public String getCoordinatorTLSUrl() {
                return "https://" + DockerConfigProvider.this.dockerIp + ":8281";
            }

            @Override
            public String getCoordinatorTwoUrl() {
                return "http://" + DockerConfigProvider.this.dockerIp + ":8581";
            }

            @Override
            public String getCoordinatorTwoTLSUrl() {
                return "https://" + DockerConfigProvider.this.dockerIp + ":8781";
            }

            @Override
            public String getOverlordUrl() {
                return "http://" + DockerConfigProvider.this.dockerIp + ":8090";
            }

            @Override
            public String getOverlordTLSUrl() {
                return "https://" + DockerConfigProvider.this.dockerIp + ":8290";
            }

            @Override
            public String getOverlordTwoUrl() {
                return "http://" + DockerConfigProvider.this.dockerIp + ":8590";
            }

            @Override
            public String getOverlordTwoTLSUrl() {
                return "https://" + DockerConfigProvider.this.dockerIp + ":8790";
            }

            @Override
            public String getRouterUrl() {
                return "http://" + DockerConfigProvider.this.dockerIp + ":8888";
            }

            @Override
            public String getRouterTLSUrl() {
                return "https://" + DockerConfigProvider.this.dockerIp + ":9088";
            }

            @Override
            public String getPermissiveRouterUrl() {
                return "http://" + DockerConfigProvider.this.dockerIp + ":8889";
            }

            @Override
            public String getPermissiveRouterTLSUrl() {
                return "https://" + DockerConfigProvider.this.dockerIp + ":9089";
            }

            @Override
            public String getNoClientAuthRouterUrl() {
                return "http://" + DockerConfigProvider.this.dockerIp + ":8890";
            }

            @Override
            public String getNoClientAuthRouterTLSUrl() {
                return "https://" + DockerConfigProvider.this.dockerIp + ":9090";
            }

            @Override
            public String getCustomCertCheckRouterUrl() {
                return "http://" + DockerConfigProvider.this.dockerIp + ":8891";
            }

            @Override
            public String getCustomCertCheckRouterTLSUrl() {
                return "https://" + DockerConfigProvider.this.dockerIp + ":9091";
            }

            @Override
            public String getBrokerUrl() {
                return "http://" + DockerConfigProvider.this.dockerIp + ":8082";
            }

            @Override
            public String getBrokerTLSUrl() {
                return "https://" + DockerConfigProvider.this.dockerIp + ":8282";
            }

            @Override
            public String getHistoricalUrl() {
                return "http://" + DockerConfigProvider.this.dockerIp + ":8083";
            }

            @Override
            public String getHistoricalTLSUrl() {
                return "https://" + DockerConfigProvider.this.dockerIp + ":8283";
            }

            @Override
            public String getIndexerUrl() {
                return "http://" + DockerConfigProvider.this.dockerIp + ":8091";
            }

            @Override
            public String getIndexerTLSUrl() {
                return "https://" + DockerConfigProvider.this.dockerIp + ":8291";
            }

            @Override
            public String getMiddleManagerHost() {
                return DockerConfigProvider.this.dockerIp;
            }

            @Override
            public String getHistoricalHost() {
                return DockerConfigProvider.this.dockerIp;
            }

            @Override
            public String getBrokerHost() {
                return DockerConfigProvider.this.dockerIp;
            }

            @Override
            public String getRouterHost() {
                return DockerConfigProvider.this.dockerIp;
            }

            @Override
            public String getCoordinatorHost() {
                return DockerConfigProvider.this.dockerIp;
            }

            @Override
            public String getCoordinatorTwoHost() {
                return DockerConfigProvider.this.dockerIp;
            }

            @Override
            public String getOverlordHost() {
                return DockerConfigProvider.this.dockerIp;
            }

            @Override
            public String getOverlordTwoHost() {
                return DockerConfigProvider.this.dockerIp;
            }

            @Override
            public String getZookeeperHosts() {
                return DockerConfigProvider.this.dockerIp + ":2181";
            }

            @Override
            public String getKafkaHost() {
                return DockerConfigProvider.this.dockerIp + ":9093";
            }

            @Override
            public String getZookeeperInternalHosts() {
                return "druid-zookeeper-kafka:2181";
            }

            @Override
            public String getKafkaInternalHost() {
                return "druid-zookeeper-kafka:9092";
            }

            @Override
            public String getBrokerInternalHost() {
                return "druid-broker";
            }

            @Override
            public String getRouterInternalHost() {
                return "druid-router";
            }

            @Override
            public String getCoordinatorInternalHost() {
                return "druid-coordinator";
            }

            @Override
            public String getCoordinatorTwoInternalHost() {
                return "druid-coordinator-two";
            }

            @Override
            public String getOverlordInternalHost() {
                return "druid-overlord";
            }

            @Override
            public String getOverlordTwoInternalHost() {
                return "druid-overlord-two";
            }

            @Override
            public String getHistoricalInternalHost() {
                return "druid-historical";
            }

            @Override
            public String getSchemaRegistryHost() {
                return DockerConfigProvider.this.dockerIp + ":8085";
            }

            @Override
            public String getSchemaRegistryInternalHost() {
                return "schema-registry:8085";
            }

            @Override
            public String getProperty(String prop) {
                return DockerConfigProvider.this.properties.get(prop);
            }

            @Override
            public String getUsername() {
                return null;
            }

            @Override
            public String getPassword() {
                return null;
            }

            @Override
            public Map<String, String> getProperties() {
                return DockerConfigProvider.this.properties;
            }

            @Override
            public boolean manageKafkaTopic() {
                return true;
            }

            @Override
            public String getExtraDatasourceNameSuffix() {
                return DockerConfigProvider.this.extraDatasourceNameSuffix;
            }

            @Override
            public String getCloudBucket() {
                return DockerConfigProvider.this.cloudBucket;
            }

            @Override
            public String getCloudPath() {
                return DockerConfigProvider.this.cloudPath;
            }

            @Override
            public String getCloudRegion() {
                return DockerConfigProvider.this.cloudRegion;
            }

            @Override
            public String getS3AssumeRoleWithExternalId() {
                return DockerConfigProvider.this.s3AssumeRoleWithExternalId;
            }

            @Override
            public String getS3AssumeRoleExternalId() {
                return DockerConfigProvider.this.s3AssumeRoleExternalId;
            }

            @Override
            public String getS3AssumeRoleWithoutExternalId() {
                return DockerConfigProvider.this.s3AssumeRoleWithoutExternalId;
            }

            @Override
            public String getAzureKey() {
                return DockerConfigProvider.this.azureKey;
            }

            @Override
            public String getHadoopGcsCredentialsPath() {
                return DockerConfigProvider.this.hadoopGcsCredentialsPath;
            }

            @Override
            public String getStreamEndpoint() {
                return DockerConfigProvider.this.streamEndpoint;
            }

            @Override
            public boolean isDocker() {
                return true;
            }

            @Override
            @Nullable
            public String getDockerHost() {
                return DockerConfigProvider.this.dockerIp;
            }
        };
    }

    static class ArbitraryPropertiesJsonDeserializer
    extends JsonDeserializer<Map<String, String>> {
        ArbitraryPropertiesJsonDeserializer() {
        }

        public Map<String, String> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            Map parsed = (Map)jsonParser.readValueAs(Map.class);
            HashMap<String, String> flat = new HashMap<String, String>();
            for (Map.Entry entry : parsed.entrySet()) {
                if (entry.getValue() instanceof Map) continue;
                flat.put((String)entry.getKey(), (String)entry.getValue());
            }
            return flat;
        }
    }
}

