/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.guice;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.multibindings.Multibinder;
import org.apache.druid.curator.CuratorConfig;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.EscalatedClient;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.java.util.emitter.core.LoggingEmitter;
import org.apache.druid.java.util.emitter.core.LoggingEmitterConfig;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.http.client.CredentialedHttpClient;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.auth.BasicCredentials;
import org.apache.druid.java.util.http.client.auth.Credentials;
import org.apache.druid.server.DruidNode;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.IntegrationTestingConfigProvider;
import org.apache.druid.testing.IntegrationTestingCuratorConfig;
import org.apache.druid.testing.guice.TestClient;

public class DruidTestModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(IntegrationTestingConfig.class).toProvider(IntegrationTestingConfigProvider.class).in(ManageLifecycle.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.test.config", IntegrationTestingConfigProvider.class);
        binder.bind(CuratorConfig.class).to(IntegrationTestingCuratorConfig.class);
        binder.bind(DruidNode.class).annotatedWith(Self.class).toInstance((Object)new DruidNode("integration-tests", "localhost", false, Integer.valueOf(9191), null, null, Boolean.valueOf(true), false));
        Multibinder.newSetBinder((Binder)binder, NodeRole.class, Self.class).addBinding().toInstance((Object)NodeRole.PEON);
    }

    @Provides
    @TestClient
    public HttpClient getHttpClient(IntegrationTestingConfig config, Lifecycle lifecycle, @EscalatedClient HttpClient delegate) {
        if (config.getUsername() != null) {
            return new CredentialedHttpClient((Credentials)new BasicCredentials(config.getUsername(), config.getPassword()), delegate);
        }
        return new CredentialedHttpClient((Credentials)new BasicCredentials("admin", "priest"), delegate);
    }

    @Provides
    @ManageLifecycle
    public ServiceEmitter getServiceEmitter(Supplier<LoggingEmitterConfig> config, ObjectMapper jsonMapper) {
        return new ServiceEmitter("", "", (Emitter)new LoggingEmitter((LoggingEmitterConfig)config.get(), jsonMapper));
    }
}

