/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl.prefetch;

import com.google.common.base.Predicate;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.prefetch.CacheManager;
import org.apache.druid.data.input.impl.prefetch.Fetcher;
import org.apache.druid.data.input.impl.prefetch.ObjectOpenFunction;
import org.apache.druid.data.input.impl.prefetch.OpenedObject;
import org.apache.druid.data.input.impl.prefetch.PrefetchConfig;
import org.apache.druid.data.input.impl.prefetch.RetryingInputStream;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.StringUtils;

public class FileFetcher<T>
extends Fetcher<T> {
    private static final int BUFFER_SIZE = 4096;
    private final ObjectOpenFunction<T> openObjectFunction;
    private final Predicate<Throwable> retryCondition;
    private final byte[] buffer;
    private final int maxFetchRetry;

    public int getMaxFetchRetry() {
        return this.maxFetchRetry;
    }

    FileFetcher(CacheManager<T> cacheManager, List<T> objects, ExecutorService fetchExecutor, @Nullable File temporaryDirectory, PrefetchConfig prefetchConfig, ObjectOpenFunction<T> openObjectFunction, Predicate<Throwable> retryCondition, Integer maxFetchRetries) {
        super(cacheManager, objects, fetchExecutor, temporaryDirectory, prefetchConfig);
        this.openObjectFunction = openObjectFunction;
        this.retryCondition = retryCondition;
        this.buffer = new byte[4096];
        this.maxFetchRetry = maxFetchRetries;
    }

    @Override
    protected long download(T object, File outFile) throws IOException {
        try {
            return (Long)RetryUtils.retry(() -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }, this.retryCondition, outFile::delete, (int)(this.maxFetchRetry + 1), (String)StringUtils.format((String)"Failed to download object[%s]", (Object[])new Object[]{object}));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    protected OpenedObject<T> generateOpenObject(T object) throws IOException {
        return new OpenedObject<T>(object, new RetryingInputStream<T>(object, this.openObjectFunction, this.retryCondition, this.getMaxFetchRetry()), FileFetcher.getNoopCloser());
    }

    private static Closeable getNoopCloser() {
        return () -> {};
    }
}

