/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import oadd.org.apache.calcite.avatica.AvaticaConnection;
import oadd.org.apache.calcite.avatica.AvaticaParameter;
import oadd.org.apache.calcite.avatica.AvaticaPreparedStatement;
import oadd.org.apache.calcite.avatica.AvaticaStatement;
import oadd.org.apache.calcite.avatica.Meta;
import oadd.org.apache.drill.exec.proto.UserProtos;
import org.apache.drill.jdbc.AlreadyClosedSqlException;
import org.apache.drill.jdbc.DrillPreparedStatement;
import org.apache.drill.jdbc.impl.DrillColumnMetaDataList;
import org.apache.drill.jdbc.impl.DrillConnectionImpl;
import org.apache.drill.jdbc.impl.DrillRemoteStatement;

abstract class DrillPreparedStatementImpl
extends AvaticaPreparedStatement
implements DrillPreparedStatement,
DrillRemoteStatement {
    private final UserProtos.PreparedStatement preparedStatementHandle;

    protected DrillPreparedStatementImpl(DrillConnectionImpl connection, Meta.StatementHandle h, Meta.Signature signature, UserProtos.PreparedStatement preparedStatementHandle, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super((AvaticaConnection)connection, h, signature, resultSetType, resultSetConcurrency, resultSetHoldability);
        connection.openStatementsRegistry.addStatement(this);
        this.preparedStatementHandle = preparedStatementHandle;
        if (preparedStatementHandle != null) {
            ((DrillColumnMetaDataList)signature.columns).updateColumnMetaData(preparedStatementHandle.getColumnsList());
        }
    }

    @Override
    protected void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw new AlreadyClosedSqlException("PreparedStatement is already closed.");
        }
    }

    UserProtos.PreparedStatement getPreparedStatementHandle() {
        return this.preparedStatementHandle;
    }

    @Override
    protected AvaticaParameter getParameter(int param) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Prepared-statement dynamic parameters are not supported.");
    }

    @Override
    public void cleanUp() {
        DrillConnectionImpl connection1 = (DrillConnectionImpl)this.connection;
        connection1.openStatementsRegistry.removeStatement(this);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkOpen();
        try {
            super.setEscapeProcessing(enable);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkOpen();
        try {
            super.setCursorName(name);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            return super.getMoreResults();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        try {
            return super.getMoreResults(current);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkOpen();
        try {
            return super.getGeneratedKeys();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        return super.executeLargeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        return super.executeLargeUpdate(sql, columnIndexes);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        return super.executeLargeUpdate(sql, columnNames);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        try {
            return super.executeUpdate(sql, autoGeneratedKeys);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        try {
            return super.executeUpdate(sql, columnIndexes);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        try {
            return super.executeUpdate(sql, columnNames);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        try {
            return super.execute(sql, autoGeneratedKeys);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        try {
            return super.execute(sql, columnIndexes);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        try {
            return super.execute(sql, columnNames);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isClosed() {
        try {
            return super.isClosed();
        }
        catch (SQLException e) {
            throw new RuntimeException("Unexpected " + e + " from AvaticaPreparedStatement.isClosed");
        }
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkOpen();
        try {
            super.setPoolable(poolable);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.checkOpen();
        super.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.checkOpen();
        super.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setLargeMaxRows(long maxRowCount) throws SQLException {
        super.setLargeMaxRows(maxRowCount);
        try (AvaticaStatement statement = this.connection.createStatement();){
            statement.execute("ALTER SESSION SET `exec.query.max_rows`=" + maxRowCount);
        }
    }
}

