/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.zookeeper.server.upgrade;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import oadd.org.apache.jute.InputArchive;
import oadd.org.apache.jute.OutputArchive;
import oadd.org.apache.jute.Record;
import oadd.org.apache.zookeeper.KeeperException;
import oadd.org.apache.zookeeper.Watcher;
import oadd.org.apache.zookeeper.data.ACL;
import oadd.org.apache.zookeeper.data.Stat;
import oadd.org.apache.zookeeper.data.StatPersistedV1;
import oadd.org.apache.zookeeper.server.WatchManager;
import oadd.org.apache.zookeeper.server.upgrade.DataNodeV1;
import oadd.org.apache.zookeeper.txn.CreateTxn;
import oadd.org.apache.zookeeper.txn.DeleteTxn;
import oadd.org.apache.zookeeper.txn.ErrorTxn;
import oadd.org.apache.zookeeper.txn.SetACLTxn;
import oadd.org.apache.zookeeper.txn.SetDataTxn;
import oadd.org.apache.zookeeper.txn.TxnHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTreeV1 {
    private static final Logger LOG = LoggerFactory.getLogger(DataTreeV1.class);
    private ConcurrentHashMap<String, DataNodeV1> nodes = new ConcurrentHashMap();
    private WatchManager dataWatches = new WatchManager();
    private WatchManager childWatches = new WatchManager();
    private Map<Long, HashSet<String>> ephemerals = new ConcurrentHashMap<Long, HashSet<String>>();
    private DataNodeV1 root = new DataNodeV1(null, new byte[0], null, new StatPersistedV1());
    public volatile long lastProcessedZxid = 0L;
    int scount;
    public boolean initialized = false;

    public Map<Long, HashSet<String>> getEphemeralsMap() {
        return this.ephemerals;
    }

    public void setEphemeralsMap(Map<Long, HashSet<String>> ephemerals) {
        this.ephemerals = ephemerals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<String> getEphemerals(long sessionId) {
        HashSet<String> retv = this.ephemerals.get(sessionId);
        if (retv == null) {
            return new HashSet<String>();
        }
        HashSet cloned = null;
        HashSet<String> hashSet = retv;
        synchronized (hashSet) {
            cloned = (HashSet)retv.clone();
        }
        return cloned;
    }

    public Collection<Long> getSessions() {
        return this.ephemerals.keySet();
    }

    public DataNodeV1 getNode(String path) {
        return this.nodes.get(path);
    }

    public DataTreeV1() {
        this.nodes.put("", this.root);
        this.nodes.put("/", this.root);
    }

    public static void copyStatPersisted(StatPersistedV1 from, StatPersistedV1 to) {
        to.setAversion(from.getAversion());
        to.setCtime(from.getCtime());
        to.setCversion(from.getCversion());
        to.setCzxid(from.getCzxid());
        to.setMtime(from.getMtime());
        to.setMzxid(from.getMzxid());
        to.setVersion(from.getVersion());
        to.setEphemeralOwner(from.getEphemeralOwner());
    }

    public static void copyStat(Stat from, Stat to) {
        to.setAversion(from.getAversion());
        to.setCtime(from.getCtime());
        to.setCversion(from.getCversion());
        to.setCzxid(from.getCzxid());
        to.setMtime(from.getMtime());
        to.setMzxid(from.getMzxid());
        to.setVersion(from.getVersion());
        to.setEphemeralOwner(from.getEphemeralOwner());
        to.setDataLength(from.getDataLength());
        to.setNumChildren(from.getNumChildren());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createNode(String path, byte[] data, List<ACL> acl, long ephemeralOwner, long zxid, long time) throws KeeperException.NoNodeException, KeeperException.NodeExistsException {
        int lastSlash = path.lastIndexOf(47);
        String parentName = path.substring(0, lastSlash);
        String childName = path.substring(lastSlash + 1);
        StatPersistedV1 stat = new StatPersistedV1();
        stat.setCtime(time);
        stat.setMtime(time);
        stat.setCzxid(zxid);
        stat.setMzxid(zxid);
        stat.setVersion(0);
        stat.setAversion(0);
        stat.setEphemeralOwner(ephemeralOwner);
        DataNodeV1 parent = this.nodes.get(parentName);
        if (parent == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNodeV1 dataNodeV1 = parent;
        synchronized (dataNodeV1) {
            if (parent.children.contains(childName)) {
                throw new KeeperException.NodeExistsException();
            }
            int cver = parent.stat.getCversion();
            parent.stat.setCversion(++cver);
            DataNodeV1 child = new DataNodeV1(parent, data, acl, stat);
            parent.children.add(childName);
            this.nodes.put(path, child);
            if (ephemeralOwner != 0L) {
                HashSet<String> list = this.ephemerals.get(ephemeralOwner);
                if (list == null) {
                    list = new HashSet();
                    this.ephemerals.put(ephemeralOwner, list);
                }
                HashSet<String> hashSet = list;
                synchronized (hashSet) {
                    list.add(path);
                }
            }
        }
        this.dataWatches.triggerWatch(path, Watcher.Event.EventType.NodeCreated);
        this.childWatches.triggerWatch(parentName.equals("") ? "/" : parentName, Watcher.Event.EventType.NodeChildrenChanged);
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNode(String path) throws KeeperException.NoNodeException {
        int lastSlash = path.lastIndexOf(47);
        String parentName = path.substring(0, lastSlash);
        String childName = path.substring(lastSlash + 1);
        DataNodeV1 node = this.nodes.get(path);
        if (node == null) {
            throw new KeeperException.NoNodeException();
        }
        this.nodes.remove(path);
        DataNodeV1 parent = this.nodes.get(parentName);
        if (parent == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNodeV1 dataNodeV1 = parent;
        synchronized (dataNodeV1) {
            HashSet<String> nodes;
            parent.children.remove(childName);
            parent.stat.setCversion(parent.stat.getCversion() + 1);
            long eowner = node.stat.getEphemeralOwner();
            if (eowner != 0L && (nodes = this.ephemerals.get(eowner)) != null) {
                HashSet<String> hashSet = nodes;
                synchronized (hashSet) {
                    nodes.remove(path);
                }
            }
            node.parent = null;
        }
        Set<Watcher> processed = this.dataWatches.triggerWatch(path, Watcher.Event.EventType.NodeDeleted);
        this.childWatches.triggerWatch(path, Watcher.Event.EventType.NodeDeleted, processed);
        this.childWatches.triggerWatch(parentName.equals("") ? "/" : parentName, Watcher.Event.EventType.NodeChildrenChanged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat setData(String path, byte[] data, int version, long zxid, long time) throws KeeperException.NoNodeException {
        Stat s = new Stat();
        DataNodeV1 n = this.nodes.get(path);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNodeV1 dataNodeV1 = n;
        synchronized (dataNodeV1) {
            n.data = data;
            n.stat.setMtime(time);
            n.stat.setMzxid(zxid);
            n.stat.setVersion(version);
            n.copyStat(s);
        }
        this.dataWatches.triggerWatch(path, Watcher.Event.EventType.NodeDataChanged);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData(String path, Stat stat, Watcher watcher) throws KeeperException.NoNodeException {
        DataNodeV1 n = this.nodes.get(path);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNodeV1 dataNodeV1 = n;
        synchronized (dataNodeV1) {
            n.copyStat(stat);
            if (watcher != null) {
                this.dataWatches.addWatch(path, watcher);
            }
            return n.data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat statNode(String path, Watcher watcher) throws KeeperException.NoNodeException {
        Stat stat = new Stat();
        DataNodeV1 n = this.nodes.get(path);
        if (watcher != null) {
            this.dataWatches.addWatch(path, watcher);
        }
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNodeV1 dataNodeV1 = n;
        synchronized (dataNodeV1) {
            n.copyStat(stat);
            return stat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getChildren(String path, Stat stat, Watcher watcher) throws KeeperException.NoNodeException {
        DataNodeV1 n = this.nodes.get(path);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNodeV1 dataNodeV1 = n;
        synchronized (dataNodeV1) {
            ArrayList<String> children = new ArrayList<String>();
            children.addAll(n.children);
            if (watcher != null) {
                this.childWatches.addWatch(path, watcher);
            }
            return children;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat setACL(String path, List<ACL> acl, int version) throws KeeperException.NoNodeException {
        Stat stat = new Stat();
        DataNodeV1 n = this.nodes.get(path);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNodeV1 dataNodeV1 = n;
        synchronized (dataNodeV1) {
            n.stat.setAversion(version);
            n.acl = acl;
            n.copyStat(stat);
            return stat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ACL> getACL(String path, Stat stat) throws KeeperException.NoNodeException {
        DataNodeV1 n = this.nodes.get(path);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNodeV1 dataNodeV1 = n;
        synchronized (dataNodeV1) {
            n.copyStat(stat);
            return new ArrayList<ACL>(n.acl);
        }
    }

    public ProcessTxnResult processTxn(TxnHeader header, Record txn) {
        ProcessTxnResult rc;
        block11: {
            rc = new ProcessTxnResult();
            String debug = "";
            try {
                rc.clientId = header.getClientId();
                rc.cxid = header.getCxid();
                rc.zxid = header.getZxid();
                if (rc.zxid > this.lastProcessedZxid) {
                    this.lastProcessedZxid = rc.zxid;
                }
                switch (header.getType()) {
                    case 1: {
                        CreateTxn createTxn = (CreateTxn)txn;
                        debug = "Create transaction for " + createTxn.getPath();
                        this.createNode(createTxn.getPath(), createTxn.getData(), createTxn.getAcl(), createTxn.getEphemeral() ? header.getClientId() : 0L, header.getZxid(), header.getTime());
                        break;
                    }
                    case 2: {
                        DeleteTxn deleteTxn = (DeleteTxn)txn;
                        debug = "Delete transaction for " + deleteTxn.getPath();
                        this.deleteNode(deleteTxn.getPath());
                        break;
                    }
                    case 5: {
                        SetDataTxn setDataTxn = (SetDataTxn)txn;
                        debug = "Set data for  transaction for " + setDataTxn.getPath();
                        break;
                    }
                    case 7: {
                        SetACLTxn setACLTxn = (SetACLTxn)txn;
                        debug = "Set ACL for  transaction for " + setACLTxn.getPath();
                        break;
                    }
                    case -11: {
                        this.killSession(header.getClientId());
                        break;
                    }
                    case -1: {
                        ErrorTxn errorTxn = (ErrorTxn)txn;
                    }
                }
            }
            catch (KeeperException e) {
                if (!this.initialized && (e.code() == KeeperException.Code.NONODE || e.code() == KeeperException.Code.NODEEXISTS)) break block11;
                LOG.warn("Failed:" + debug, e);
            }
        }
        return rc;
    }

    void killSession(long session) {
        HashSet<String> list = this.ephemerals.remove(session);
        if (list != null) {
            for (String path : list) {
                try {
                    this.deleteNode(path);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Deleting ephemeral node " + path + " for session 0x" + Long.toHexString(session));
                }
                catch (KeeperException.NoNodeException e) {
                    LOG.warn("Ignoring NoNodeException for path " + path + " while removing ephemeral for dead session 0x" + Long.toHexString(session));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serializeNode(OutputArchive oa, StringBuilder path) throws IOException, InterruptedException {
        String pathString = path.toString();
        DataNodeV1 node = this.getNode(pathString);
        if (node == null) {
            return;
        }
        String[] children = null;
        DataNodeV1 dataNodeV1 = node;
        synchronized (dataNodeV1) {
            ++this.scount;
            oa.writeString(pathString, "path");
            oa.writeRecord(node, "node");
            children = node.children.toArray(new String[node.children.size()]);
        }
        path.append('/');
        int off = path.length();
        if (children != null) {
            for (String child : children) {
                path.delete(off, Integer.MAX_VALUE);
                path.append(child);
                this.serializeNode(oa, path);
            }
        }
    }

    public void serialize(OutputArchive oa, String tag) throws IOException, InterruptedException {
        this.scount = 0;
        this.serializeNode(oa, new StringBuilder(""));
        if (this.root != null) {
            oa.writeString("/", "path");
        }
    }

    public void deserialize(InputArchive ia, String tag) throws IOException {
        this.nodes.clear();
        String path = ia.readString("path");
        while (!path.equals("/")) {
            DataNodeV1 node = new DataNodeV1();
            ia.readRecord(node, "node");
            this.nodes.put(path, node);
            int lastSlash = path.lastIndexOf(47);
            if (lastSlash == -1) {
                this.root = node;
            } else {
                String parentPath = path.substring(0, lastSlash);
                node.parent = this.nodes.get(parentPath);
                node.parent.children.add(path.substring(lastSlash + 1));
                long eowner = node.stat.getEphemeralOwner();
                if (eowner != 0L) {
                    HashSet<String> list = this.ephemerals.get(eowner);
                    if (list == null) {
                        list = new HashSet();
                        this.ephemerals.put(eowner, list);
                    }
                    list.add(path);
                }
            }
            path = ia.readString("path");
        }
        this.nodes.put("/", this.root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpEphemerals() {
        Set<Long> keys = this.ephemerals.keySet();
        StringBuilder sb = new StringBuilder("Sessions with Ephemerals (" + keys.size() + "):\n");
        for (long k : keys) {
            HashSet<String> tmp;
            sb.append("0x" + Long.toHexString(k));
            sb.append(":\n");
            HashSet<String> hashSet = tmp = this.ephemerals.get(k);
            synchronized (hashSet) {
                for (String path : tmp) {
                    sb.append("\t" + path + "\n");
                }
            }
        }
        return sb.toString();
    }

    public void removeCnxn(Watcher watcher) {
        this.dataWatches.removeWatcher(watcher);
        this.childWatches.removeWatcher(watcher);
    }

    public void clear() {
        this.root = null;
        this.nodes.clear();
        this.ephemerals.clear();
    }

    public static class ProcessTxnResult {
        public long clientId;
        public int cxid;
        public long zxid;

        public boolean equals(Object o) {
            if (o instanceof ProcessTxnResult) {
                ProcessTxnResult other = (ProcessTxnResult)o;
                return other.clientId == this.clientId && other.cxid == this.cxid;
            }
            return false;
        }

        public int hashCode() {
            return (int)((this.clientId ^ (long)this.cxid) % Integer.MAX_VALUE);
        }
    }
}

