/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.metrics2;

import java.util.StringJoiner;
import oadd.com.google.common.base.Objects;
import oadd.com.google.common.base.Preconditions;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.metrics2.MetricType;
import oadd.org.apache.hadoop.metrics2.MetricsInfo;
import oadd.org.apache.hadoop.metrics2.MetricsVisitor;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class AbstractMetric
implements MetricsInfo {
    private final MetricsInfo info;

    protected AbstractMetric(MetricsInfo info) {
        this.info = Preconditions.checkNotNull(info, "metric info");
    }

    @Override
    public String name() {
        return this.info.name();
    }

    @Override
    public String description() {
        return this.info.description();
    }

    protected MetricsInfo info() {
        return this.info;
    }

    public abstract Number value();

    public abstract MetricType type();

    public abstract void visit(MetricsVisitor var1);

    public boolean equals(Object obj) {
        if (obj instanceof AbstractMetric) {
            AbstractMetric other = (AbstractMetric)obj;
            return Objects.equal(this.info, other.info()) && Objects.equal(this.value(), other.value());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.info, this.value());
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "{", "}").add("info=" + this.info).add("value=" + this.value()).toString();
    }
}

