/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.fs;

import java.util.Arrays;
import java.util.List;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.fs.StorageType;
import oadd.org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class QuotaUsage {
    private long fileAndDirectoryCount;
    private long quota;
    private long spaceConsumed;
    private long spaceQuota;
    private long[] typeConsumed;
    private long[] typeQuota;
    protected static final String QUOTA_STRING_FORMAT = "%12s %15s ";
    protected static final String SPACE_QUOTA_STRING_FORMAT = "%15s %15s ";
    protected static final String[] QUOTA_HEADER_FIELDS = new String[]{"QUOTA", "REM_QUOTA", "SPACE_QUOTA", "REM_SPACE_QUOTA"};
    protected static final String QUOTA_HEADER = String.format("%12s %15s %15s %15s ", QUOTA_HEADER_FIELDS);
    private static final String STORAGE_TYPE_SUMMARY_FORMAT = "%13s %17s ";
    private static final String QUOTA_NONE = "none";
    private static final String QUOTA_INF = "inf";

    protected QuotaUsage() {
    }

    protected QuotaUsage(Builder builder) {
        this.fileAndDirectoryCount = builder.fileAndDirectoryCount;
        this.quota = builder.quota;
        this.spaceConsumed = builder.spaceConsumed;
        this.spaceQuota = builder.spaceQuota;
        this.typeConsumed = builder.typeConsumed;
        this.typeQuota = builder.typeQuota;
    }

    protected void setQuota(long quota) {
        this.quota = quota;
    }

    protected void setSpaceConsumed(long spaceConsumed) {
        this.spaceConsumed = spaceConsumed;
    }

    protected void setSpaceQuota(long spaceQuota) {
        this.spaceQuota = spaceQuota;
    }

    public long getFileAndDirectoryCount() {
        return this.fileAndDirectoryCount;
    }

    public long getQuota() {
        return this.quota;
    }

    public long getSpaceConsumed() {
        return this.spaceConsumed;
    }

    public long getSpaceQuota() {
        return this.spaceQuota;
    }

    public long getTypeQuota(StorageType type) {
        return this.typeQuota != null ? this.typeQuota[type.ordinal()] : -1L;
    }

    public long getTypeConsumed(StorageType type) {
        return this.typeConsumed != null ? this.typeConsumed[type.ordinal()] : 0L;
    }

    private long[] getTypesQuota() {
        return this.typeQuota;
    }

    private long[] getTypesConsumed() {
        return this.typeConsumed;
    }

    public boolean isTypeQuotaSet() {
        if (this.typeQuota == null) {
            return false;
        }
        for (StorageType t : StorageType.getTypesSupportingQuota()) {
            if (this.typeQuota[t.ordinal()] <= 0L) continue;
            return true;
        }
        return false;
    }

    public boolean isTypeConsumedAvailable() {
        if (this.typeConsumed == null) {
            return false;
        }
        for (StorageType t : StorageType.getTypesSupportingQuota()) {
            if (this.typeConsumed[t.ordinal()] <= 0L) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object to) {
        return this == to || to instanceof QuotaUsage && this.getFileAndDirectoryCount() == ((QuotaUsage)to).getFileAndDirectoryCount() && this.getQuota() == ((QuotaUsage)to).getQuota() && this.getSpaceConsumed() == ((QuotaUsage)to).getSpaceConsumed() && this.getSpaceQuota() == ((QuotaUsage)to).getSpaceQuota() && Arrays.equals(this.getTypesQuota(), ((QuotaUsage)to).getTypesQuota()) && Arrays.equals(this.getTypesConsumed(), ((QuotaUsage)to).getTypesConsumed());
    }

    public int hashCode() {
        long result = this.getFileAndDirectoryCount() ^ this.getQuota() ^ this.getSpaceConsumed() ^ this.getSpaceQuota();
        if (this.getTypesQuota() != null) {
            for (long quota : this.getTypesQuota()) {
                result ^= quota;
            }
        }
        if (this.getTypesConsumed() != null) {
            for (long consumed : this.getTypesConsumed()) {
                result ^= consumed;
            }
        }
        return (int)result;
    }

    public static String getHeader() {
        return QUOTA_HEADER;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean hOption) {
        return this.toString(hOption, false, null);
    }

    public String toString(boolean hOption, boolean tOption, List<StorageType> types) {
        if (tOption) {
            return this.getTypesQuotaUsage(hOption, types);
        }
        return this.getQuotaUsage(hOption);
    }

    protected String getQuotaUsage(boolean hOption) {
        String quotaStr = QUOTA_NONE;
        String quotaRem = QUOTA_INF;
        String spaceQuotaStr = QUOTA_NONE;
        String spaceQuotaRem = QUOTA_INF;
        if (this.quota > 0L) {
            quotaStr = this.formatSize(this.quota, hOption);
            quotaRem = this.formatSize(this.quota - this.fileAndDirectoryCount, hOption);
        }
        if (this.spaceQuota >= 0L) {
            spaceQuotaStr = this.formatSize(this.spaceQuota, hOption);
            spaceQuotaRem = this.formatSize(this.spaceQuota - this.spaceConsumed, hOption);
        }
        return String.format("%12s %15s %15s %15s ", quotaStr, quotaRem, spaceQuotaStr, spaceQuotaRem);
    }

    protected String getTypesQuotaUsage(boolean hOption, List<StorageType> types) {
        StringBuffer content = new StringBuffer();
        for (StorageType st : types) {
            long typeQuota = this.getTypeQuota(st);
            long typeConsumed = this.getTypeConsumed(st);
            String quotaStr = QUOTA_NONE;
            String quotaRem = QUOTA_INF;
            if (typeQuota >= 0L) {
                quotaStr = this.formatSize(typeQuota, hOption);
                quotaRem = this.formatSize(typeQuota - typeConsumed, hOption);
            }
            content.append(String.format(STORAGE_TYPE_SUMMARY_FORMAT, quotaStr, quotaRem));
        }
        return content.toString();
    }

    public static String getStorageTypeHeader(List<StorageType> storageTypes) {
        StringBuffer header = new StringBuffer();
        for (StorageType st : storageTypes) {
            String storageName = st.toString();
            header.append(String.format(STORAGE_TYPE_SUMMARY_FORMAT, storageName + "_QUOTA", "REM_" + storageName + "_QUOTA"));
        }
        return header.toString();
    }

    private String formatSize(long size, boolean humanReadable) {
        return humanReadable ? StringUtils.TraditionalBinaryPrefix.long2String(size, "", 1) : String.valueOf(size);
    }

    public static class Builder {
        private long fileAndDirectoryCount;
        private long quota = -1L;
        private long spaceConsumed;
        private long spaceQuota = -1L;
        private long[] typeConsumed = new long[StorageType.values().length];
        private long[] typeQuota = new long[StorageType.values().length];

        public Builder() {
            for (int i = 0; i < this.typeQuota.length; ++i) {
                this.typeQuota[i] = -1L;
            }
        }

        public Builder fileAndDirectoryCount(long count) {
            this.fileAndDirectoryCount = count;
            return this;
        }

        public Builder quota(long quota) {
            this.quota = quota;
            return this;
        }

        public Builder spaceConsumed(long spaceConsumed) {
            this.spaceConsumed = spaceConsumed;
            return this;
        }

        public Builder spaceQuota(long spaceQuota) {
            this.spaceQuota = spaceQuota;
            return this;
        }

        public Builder typeConsumed(long[] typeConsumed) {
            for (int i = 0; i < typeConsumed.length; ++i) {
                this.typeConsumed[i] = typeConsumed[i];
            }
            return this;
        }

        public Builder typeQuota(StorageType type, long quota) {
            this.typeQuota[type.ordinal()] = quota;
            return this;
        }

        public Builder typeConsumed(StorageType type, long consumed) {
            this.typeConsumed[type.ordinal()] = consumed;
            return this;
        }

        public Builder typeQuota(long[] typeQuota) {
            for (int i = 0; i < typeQuota.length; ++i) {
                this.typeQuota[i] = typeQuota[i];
            }
            return this;
        }

        public QuotaUsage build() {
            return new QuotaUsage(this);
        }
    }
}

