/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.fs;

import java.io.File;
import oadd.org.apache.hadoop.util.Shell;

public class DUHelper {
    private int folderCount = 0;
    private int fileCount = 0;
    private double usage = 0.0;
    private long folderSize = -1L;

    private DUHelper() {
    }

    public static long getFolderUsage(String folder) {
        return new DUHelper().calculateFolderSize(folder);
    }

    private long calculateFolderSize(String folder) {
        if (folder == null) {
            throw new IllegalArgumentException("folder");
        }
        File f = new File(folder);
        this.folderSize = this.getFileSize(f);
        return this.folderSize;
    }

    public String check(String folder) {
        if (folder == null) {
            throw new IllegalArgumentException("folder");
        }
        File f = new File(folder);
        this.folderSize = this.getFileSize(f);
        this.usage = 1.0 * (double)(f.getTotalSpace() - f.getFreeSpace()) / (double)f.getTotalSpace();
        return String.format("used %d files %d disk in use %f", this.folderSize, this.fileCount, this.usage);
    }

    public long getFileCount() {
        return this.fileCount;
    }

    public double getUsage() {
        return this.usage;
    }

    private long getFileSize(File folder) {
        ++this.folderCount;
        long foldersize = 0L;
        if (folder.isFile()) {
            return folder.length();
        }
        File[] filelist = folder.listFiles();
        if (filelist == null) {
            return 0L;
        }
        for (int i = 0; i < filelist.length; ++i) {
            if (filelist[i].isDirectory()) {
                foldersize += this.getFileSize(filelist[i]);
                continue;
            }
            ++this.fileCount;
            foldersize += filelist[i].length();
        }
        return foldersize;
    }

    public static void main(String[] args) {
        if (Shell.WINDOWS) {
            System.out.println("Windows: " + DUHelper.getFolderUsage(args[0]));
        } else {
            System.out.println("Other: " + DUHelper.getFolderUsage(args[0]));
        }
    }
}

