/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.holders.NullableTinyIntHolder;
import oadd.org.apache.drill.exec.expr.holders.TinyIntHolder;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.TinyIntWriter;

public class NullableTinyIntHolderReaderImpl
extends AbstractFieldReader {
    private NullableTinyIntHolder holder;

    public NullableTinyIntHolderReaderImpl(NullableTinyIntHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return NullableTinyIntHolder.TYPE;
    }

    @Override
    public boolean isSet() {
        return this.holder.isSet == 1;
    }

    @Override
    public void read(TinyIntHolder h) {
        h.value = this.holder.value;
    }

    @Override
    public void read(NullableTinyIntHolder h) {
        h.value = this.holder.value;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public Byte readByte() {
        if (!this.isSet()) {
            return null;
        }
        Byte value = new Byte(this.holder.value);
        return value;
    }

    @Override
    public Object readObject() {
        return this.readSingleObject();
    }

    private Object readSingleObject() {
        if (!this.isSet()) {
            return null;
        }
        Byte value = new Byte(this.holder.value);
        return value;
    }

    @Override
    public void copyAsValue(TinyIntWriter writer) {
        if (this.isSet()) {
            writer.writeTinyInt(this.holder.value);
        }
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        TinyIntWriter impl = writer.tinyInt(name);
        if (this.isSet()) {
            impl.writeTinyInt(this.holder.value);
        }
    }
}

