/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import java.math.BigDecimal;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.holders.NullableDecimal9Holder;
import oadd.org.apache.drill.exec.expr.holders.ValueHolder;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.vector.NullableDecimal9Vector;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import oadd.org.apache.drill.exec.vector.complex.impl.NullableDecimal9WriterImpl;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.Decimal9Writer;
import oadd.org.apache.drill.exec.vector.complex.writer.FieldWriter;

public class NullableDecimal9ReaderImpl
extends AbstractFieldReader {
    private final NullableDecimal9Vector vector;

    public NullableDecimal9ReaderImpl(NullableDecimal9Vector vector) {
        this.vector = vector;
    }

    @Override
    public TypeProtos.MajorType getType() {
        return this.vector.getField().getType();
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public boolean isSet() {
        return !this.vector.getAccessor().isNull(this.idx());
    }

    @Override
    public void copyAsValue(Decimal9Writer writer) {
        NullableDecimal9WriterImpl impl = (NullableDecimal9WriterImpl)writer;
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        NullableDecimal9WriterImpl impl = (NullableDecimal9WriterImpl)writer.decimal9(name);
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void read(ValueHolder h) {
        this.read((NullableDecimal9Holder)h);
    }

    @Override
    public void read(NullableDecimal9Holder h) {
        this.vector.getAccessor().get(this.idx(), h);
    }

    @Override
    public BigDecimal readBigDecimal() {
        return this.vector.getAccessor().getObject(this.idx());
    }

    public void copyValue(FieldWriter w) {
    }

    @Override
    public Object readObject() {
        return this.vector.getAccessor().getObject(this.idx());
    }
}

