/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor;

import java.sql.Timestamp;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.vector.TimeStampVector;
import oadd.org.apache.drill.exec.vector.accessor.AbstractSqlAccessor;
import oadd.org.joda.time.DateTimeZone;
import oadd.org.joda.time.LocalDateTime;

public class TimeStampAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.required(TypeProtos.MinorType.TIMESTAMP);
    private final TimeStampVector.Accessor ac;

    public TimeStampAccessor(TimeStampVector vector) {
        this.ac = vector.getAccessor();
    }

    @Override
    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    @Override
    public boolean isNull(int index) {
        return false;
    }

    @Override
    public Class<?> getObjectClass() {
        return Timestamp.class;
    }

    @Override
    public Object getObject(int index) {
        return this.getTimestamp(index);
    }

    @Override
    public Timestamp getTimestamp(int index) {
        LocalDateTime dateTime = new LocalDateTime(this.ac.get(index), DateTimeZone.UTC);
        return new Timestamp(dateTime.toDate().getTime());
    }
}

