/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.util;

import java.io.File;
import java.util.HashMap;
import java.util.Optional;
import oadd.org.apache.drill.common.exceptions.ExecutionSetupException;
import oadd.org.apache.drill.common.logical.StoragePluginConfig;
import oadd.org.apache.drill.exec.store.StoragePluginRegistry;
import oadd.org.apache.drill.exec.store.dfs.FileSystemConfig;
import oadd.org.apache.drill.exec.store.dfs.FileSystemPlugin;
import oadd.org.apache.drill.exec.store.dfs.WorkspaceConfig;
import oadd.org.apache.drill.exec.store.easy.sequencefile.SequenceFileFormatConfig;
import oadd.org.apache.drill.exec.store.easy.text.TextFormatPlugin;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;

public class StoragePluginTestUtils {
    public static final String CP_PLUGIN_NAME = "cp";
    public static final String DFS_PLUGIN_NAME = "dfs";
    public static final String TMP_SCHEMA = "tmp";
    public static final String ROOT_SCHEMA = "root";
    public static final String DFS_TMP_SCHEMA = "dfs.tmp";
    public static final String DFS_DEFAULT_SCHEMA = "dfs.default";
    public static final String DFS_ROOT_SCHEMA = "dfs.root";
    public static final String UNIT_TEST_PROP_PREFIX = "drillJDBCUnitTests";
    public static final String UNIT_TEST_DFS_TMP_PROP = "drillJDBCUnitTests.dfs.tmp";
    public static final String UNIT_TEST_DFS_DEFAULT_PROP = "drillJDBCUnitTests.dfs.default";
    public static final String UNIT_TEST_DFS_ROOT_PROP = "drillJDBCUnitTests.dfs.root";

    public static void updateSchemaLocation(String pluginName, StoragePluginRegistry pluginRegistry, File tmpDirPath, String ... schemas) throws ExecutionSetupException {
        FileSystemPlugin plugin = (FileSystemPlugin)pluginRegistry.getPlugin(pluginName);
        FileSystemConfig pluginConfig = (FileSystemConfig)plugin.getConfig();
        HashMap<String, WorkspaceConfig> newWorkspaces = new HashMap<String, WorkspaceConfig>();
        Optional.ofNullable(pluginConfig.getWorkspaces()).ifPresent(newWorkspaces::putAll);
        if (schemas.length == 0) {
            schemas = new String[]{TMP_SCHEMA};
        }
        for (String schema : schemas) {
            WorkspaceConfig workspaceConfig = (WorkspaceConfig)newWorkspaces.get(schema);
            String inputFormat = workspaceConfig == null ? null : workspaceConfig.getDefaultInputFormat();
            WorkspaceConfig newWorkspaceConfig = new WorkspaceConfig(tmpDirPath.getAbsolutePath(), true, inputFormat, false);
            newWorkspaces.put(schema, newWorkspaceConfig);
        }
        FileSystemConfig newPluginConfig = new FileSystemConfig(pluginConfig.getConnection(), pluginConfig.getConfig(), newWorkspaces, pluginConfig.getFormats());
        newPluginConfig.setEnabled(Boolean.valueOf(pluginConfig.isEnabled()));
        pluginRegistry.createOrUpdate(pluginName, (StoragePluginConfig)newPluginConfig, true);
    }

    public static void configureFormatPlugins(StoragePluginRegistry pluginRegistry) throws ExecutionSetupException {
        StoragePluginTestUtils.configureFormatPlugins(pluginRegistry, CP_PLUGIN_NAME);
        StoragePluginTestUtils.configureFormatPlugins(pluginRegistry, DFS_PLUGIN_NAME);
    }

    public static void configureFormatPlugins(StoragePluginRegistry pluginRegistry, String storagePlugin) throws ExecutionSetupException {
        FileSystemPlugin fileSystemPlugin = (FileSystemPlugin)pluginRegistry.getPlugin(storagePlugin);
        FileSystemConfig fileSystemConfig = (FileSystemConfig)fileSystemPlugin.getConfig();
        HashMap<String, Object> newFormats = new HashMap<String, Object>();
        Optional.ofNullable(fileSystemConfig.getFormats()).ifPresent(newFormats::putAll);
        TextFormatPlugin.TextFormatConfig textConfig = new TextFormatPlugin.TextFormatConfig();
        textConfig.extensions = ImmutableList.of("txt");
        textConfig.fieldDelimiter = '\u0000';
        newFormats.put("txt", textConfig);
        TextFormatPlugin.TextFormatConfig ssvConfig = new TextFormatPlugin.TextFormatConfig();
        ssvConfig.extensions = ImmutableList.of("ssv");
        ssvConfig.fieldDelimiter = (char)32;
        newFormats.put("ssv", ssvConfig);
        TextFormatPlugin.TextFormatConfig psvConfig = new TextFormatPlugin.TextFormatConfig();
        psvConfig.extensions = ImmutableList.of("tbl");
        psvConfig.fieldDelimiter = (char)124;
        newFormats.put("psv", psvConfig);
        SequenceFileFormatConfig seqConfig = new SequenceFileFormatConfig();
        seqConfig.extensions = ImmutableList.of("seq");
        newFormats.put("sequencefile", seqConfig);
        TextFormatPlugin.TextFormatConfig csvhtestConfig = new TextFormatPlugin.TextFormatConfig();
        csvhtestConfig.extensions = ImmutableList.of("csvh-test");
        csvhtestConfig.fieldDelimiter = (char)44;
        csvhtestConfig.extractHeader = true;
        csvhtestConfig.skipFirstLine = true;
        newFormats.put("csvh-test", csvhtestConfig);
        FileSystemConfig newFileSystemConfig = new FileSystemConfig(fileSystemConfig.getConnection(), fileSystemConfig.getConfig(), fileSystemConfig.getWorkspaces(), newFormats);
        newFileSystemConfig.setEnabled(Boolean.valueOf(fileSystemConfig.isEnabled()));
        pluginRegistry.createOrUpdate(storagePlugin, (StoragePluginConfig)newFileSystemConfig, true);
    }
}

