/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.server.options;

import java.util.EnumSet;
import oadd.com.fasterxml.jackson.annotation.JsonCreator;
import oadd.com.fasterxml.jackson.annotation.JsonIgnore;
import oadd.com.fasterxml.jackson.annotation.JsonInclude;
import oadd.com.fasterxml.jackson.annotation.JsonProperty;
import oadd.org.apache.drill.exec.server.options.PersistedOptionValue;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OptionValue
implements Comparable<OptionValue> {
    public static final String JSON_KIND = "kind";
    public static final String JSON_ACCESSIBLE_SCOPES = "accessibleScopes";
    public static final String JSON_NAME = "name";
    public static final String JSON_NUM_VAL = "num_val";
    public static final String JSON_STRING_VAL = "string_val";
    public static final String JSON_BOOL_VAL = "bool_val";
    public static final String JSON_FLOAT_VAL = "float_val";
    public static final String JSON_INTEGER_VAL = "int_val";
    public static final String JSON_SCOPE = "scope";
    public final String name;
    public final Kind kind;
    public final AccessibleScopes accessibleScopes;
    public final Long num_val;
    public final String string_val;
    public final Boolean bool_val;
    public final Double float_val;
    public final OptionScope scope;

    public static OptionValue create(AccessibleScopes accessibleScopes, String name, long val, OptionScope scope) {
        return new OptionValue(Kind.LONG, accessibleScopes, name, val, null, null, null, scope);
    }

    public static OptionValue create(AccessibleScopes accessibleScopes, String name, boolean bool, OptionScope scope) {
        return new OptionValue(Kind.BOOLEAN, accessibleScopes, name, null, null, bool, null, scope);
    }

    public static OptionValue create(AccessibleScopes accessibleScopes, String name, String val, OptionScope scope) {
        return new OptionValue(Kind.STRING, accessibleScopes, name, null, val, null, null, scope);
    }

    public static OptionValue create(AccessibleScopes accessibleScopes, String name, double val, OptionScope scope) {
        return new OptionValue(Kind.DOUBLE, accessibleScopes, name, null, null, null, val, scope);
    }

    public static OptionValue create(Kind kind, AccessibleScopes accessibleScopes, String name, String val, OptionScope scope) {
        switch (kind) {
            case BOOLEAN: {
                return OptionValue.create(accessibleScopes, name, Boolean.valueOf(val), scope);
            }
            case STRING: {
                return OptionValue.create(accessibleScopes, name, val, scope);
            }
            case DOUBLE: {
                return OptionValue.create(accessibleScopes, name, Double.parseDouble(val), scope);
            }
            case LONG: {
                return OptionValue.create(accessibleScopes, name, Long.parseLong(val), scope);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported kind %s", new Object[]{kind}));
    }

    public static OptionValue create(AccessibleScopes type, String name, Object val, OptionScope scope) {
        if (val instanceof Boolean) {
            return OptionValue.create(type, name, (Boolean)val, scope);
        }
        if (val instanceof Long) {
            return OptionValue.create(type, name, (Long)val, scope);
        }
        if (val instanceof Integer) {
            return OptionValue.create(type, name, ((Integer)val).longValue(), scope);
        }
        if (val instanceof String) {
            return OptionValue.create(type, name, (String)val, scope);
        }
        if (val instanceof Double) {
            return OptionValue.create(type, name, (Double)val, scope);
        }
        if (val instanceof Float) {
            return OptionValue.create(type, name, ((Float)val).doubleValue(), scope);
        }
        throw new IllegalArgumentException(String.format("Unsupported type %s", val.getClass()));
    }

    @JsonCreator
    private OptionValue(@JsonProperty(value="kind") Kind kind, @JsonProperty(value="accessibleScopes") AccessibleScopes accessibleScopes, @JsonProperty(value="name") String name, @JsonProperty(value="num_val") Long num_val, @JsonProperty(value="string_val") String string_val, @JsonProperty(value="bool_val") Boolean bool_val, @JsonProperty(value="float_val") Double float_val, @JsonProperty(value="scope") OptionScope scope) {
        Preconditions.checkArgument(num_val != null || string_val != null || bool_val != null || float_val != null);
        this.kind = kind;
        this.accessibleScopes = accessibleScopes;
        this.name = name;
        this.float_val = float_val;
        this.num_val = num_val;
        this.string_val = string_val;
        this.bool_val = bool_val;
        this.scope = scope;
    }

    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public Object getValue() {
        switch (this.kind) {
            case BOOLEAN: {
                return this.bool_val;
            }
            case LONG: {
                return this.num_val;
            }
            case STRING: {
                return this.string_val;
            }
            case DOUBLE: {
                return this.float_val;
            }
        }
        return null;
    }

    @JsonIgnore
    public OptionScope getScope() {
        return this.scope;
    }

    public PersistedOptionValue toPersisted() {
        return new PersistedOptionValue(this.kind, this.name, this.num_val, this.string_val, this.bool_val, this.float_val);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bool_val == null ? 0 : this.bool_val.hashCode());
        result = 31 * result + (this.float_val == null ? 0 : this.float_val.hashCode());
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.num_val == null ? 0 : this.num_val.hashCode());
        result = 31 * result + (this.string_val == null ? 0 : this.string_val.hashCode());
        result = 31 * result + (this.accessibleScopes == null ? 0 : this.accessibleScopes.hashCode());
        return result;
    }

    public boolean equalsIgnoreType(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OptionValue other = (OptionValue)obj;
        if (this.bool_val == null ? other.bool_val != null : !this.bool_val.equals(other.bool_val)) {
            return false;
        }
        if (this.float_val == null ? other.float_val != null : !this.float_val.equals(other.float_val)) {
            return false;
        }
        if (this.kind != other.kind) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.num_val == null ? other.num_val != null : !this.num_val.equals(other.num_val)) {
            return false;
        }
        return !(this.string_val == null ? other.string_val != null : !this.string_val.equals(other.string_val));
    }

    public boolean equals(Object obj) {
        if (!this.equalsIgnoreType(obj)) {
            return false;
        }
        OptionValue other = (OptionValue)obj;
        return this.accessibleScopes == other.accessibleScopes;
    }

    @Override
    public int compareTo(OptionValue o) {
        return this.name.compareTo(o.name);
    }

    public String toString() {
        return "OptionValue [ accessibleScopes=" + (Object)((Object)this.accessibleScopes) + ", optionScope=" + (Object)((Object)this.scope) + ", name=" + this.name + ", value=" + this.getValue() + " ]";
    }

    public static enum OptionScope {
        BOOT,
        SYSTEM,
        SESSION,
        QUERY;

    }

    public static enum Kind {
        BOOLEAN,
        LONG,
        STRING,
        DOUBLE;

    }

    public static enum AccessibleScopes {
        BOOT(EnumSet.of(OptionScope.BOOT)),
        SYSTEM(EnumSet.of(OptionScope.BOOT, OptionScope.SYSTEM)),
        SESSION(EnumSet.of(OptionScope.BOOT, OptionScope.SESSION)),
        QUERY(EnumSet.of(OptionScope.BOOT, OptionScope.QUERY)),
        SYSTEM_AND_SESSION(EnumSet.of(OptionScope.BOOT, OptionScope.SYSTEM, OptionScope.SESSION)),
        SESSION_AND_QUERY(EnumSet.of(OptionScope.BOOT, OptionScope.SESSION, OptionScope.QUERY)),
        ALL(EnumSet.of(OptionScope.BOOT, OptionScope.SYSTEM, OptionScope.SESSION, OptionScope.QUERY));

        private EnumSet<OptionScope> scopes;

        private AccessibleScopes(EnumSet<OptionScope> scopes) {
            this.scopes = Preconditions.checkNotNull(scopes);
        }

        public boolean inScopeOf(OptionScope scope) {
            return this.scopes.contains((Object)scope);
        }
    }
}

