/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.schema.json.jackson;

import java.io.IOException;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.core.JsonToken;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;

public class JacksonHelper {
    public static final TypeProtos.MajorType STRING_TYPE = Types.optional(TypeProtos.MinorType.VARCHAR);
    public static final TypeProtos.MajorType REPEATED_STRING_TYPE = Types.repeated(TypeProtos.MinorType.VARCHAR);
    public static final TypeProtos.MajorType BOOLEAN_TYPE = Types.optional(TypeProtos.MinorType.BIT);
    public static final TypeProtos.MajorType REPEATED_BOOLEAN_TYPE = Types.repeated(TypeProtos.MinorType.BIT);
    public static final TypeProtos.MajorType ARRAY_TYPE = Types.repeated(TypeProtos.MinorType.LATE);
    public static final TypeProtos.MajorType MAP_TYPE = Types.repeated(TypeProtos.MinorType.MAP);
    public static final TypeProtos.MajorType INT_TYPE = Types.optional(TypeProtos.MinorType.BIGINT);
    public static final TypeProtos.MajorType REPEATED_INT_TYPE = Types.repeated(TypeProtos.MinorType.BIGINT);
    public static final TypeProtos.MajorType FLOAT_TYPE = Types.optional(TypeProtos.MinorType.FLOAT4);
    public static final TypeProtos.MajorType REPEATED_FLOAT_TYPE = Types.repeated(TypeProtos.MinorType.FLOAT4);
    public static final TypeProtos.MajorType NULL_TYPE = Types.optional(TypeProtos.MinorType.LATE);

    public static TypeProtos.MajorType getFieldType(JsonToken token, boolean repeated) {
        if (repeated) {
            switch (token) {
                case VALUE_STRING: {
                    return REPEATED_STRING_TYPE;
                }
                case VALUE_FALSE: 
                case VALUE_TRUE: {
                    return REPEATED_BOOLEAN_TYPE;
                }
                case START_ARRAY: {
                    return ARRAY_TYPE;
                }
                case START_OBJECT: {
                    return MAP_TYPE;
                }
                case VALUE_NUMBER_INT: {
                    return REPEATED_INT_TYPE;
                }
                case VALUE_NUMBER_FLOAT: {
                    return REPEATED_FLOAT_TYPE;
                }
            }
        } else {
            switch (token) {
                case VALUE_STRING: {
                    return STRING_TYPE;
                }
                case VALUE_FALSE: 
                case VALUE_TRUE: {
                    return BOOLEAN_TYPE;
                }
                case START_ARRAY: {
                    return ARRAY_TYPE;
                }
                case START_OBJECT: {
                    return MAP_TYPE;
                }
                case VALUE_NUMBER_INT: {
                    return INT_TYPE;
                }
                case VALUE_NUMBER_FLOAT: {
                    return FLOAT_TYPE;
                }
                case VALUE_NULL: {
                    return NULL_TYPE;
                }
            }
        }
        throw new UnsupportedOperationException("Unsupported Jackson type: " + (Object)((Object)token) + ", Repeated: " + repeated);
    }

    public static Object getValueFromFieldType(JsonParser parser, TypeProtos.MinorType fieldType) throws IOException {
        switch (fieldType) {
            case BIGINT: {
                return parser.getLongValue();
            }
            case VARCHAR: {
                return parser.getValueAsString();
            }
            case FLOAT4: {
                return Float.valueOf(parser.getFloatValue());
            }
            case BIT: {
                return parser.getBooleanValue();
            }
            case LATE: 
            case NULL: {
                return null;
            }
        }
        throw new RuntimeException("Unexpected Field type to return value: " + fieldType.toString());
    }
}

