/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.metadata;

import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.metadata.ColumnBuilder;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.MapBuilder;
import oadd.org.apache.drill.exec.record.metadata.RepeatedListBuilder;
import oadd.org.apache.drill.exec.record.metadata.SchemaBuilder;
import oadd.org.apache.drill.exec.record.metadata.SchemaContainer;
import oadd.org.apache.drill.exec.record.metadata.TupleSchema;
import oadd.org.apache.drill.exec.record.metadata.UnionBuilder;

public class TupleBuilder
implements SchemaContainer {
    private final TupleSchema schema = new TupleSchema();

    @Override
    public void addColumn(ColumnMetadata column) {
        this.schema.add(column);
    }

    public void add(String name, TypeProtos.MajorType type) {
        this.add(MaterializedField.create(name, type));
    }

    public void add(MaterializedField col) {
        this.schema.add(col);
    }

    public void add(String name, TypeProtos.MinorType type, TypeProtos.DataMode mode) {
        this.add(SchemaBuilder.columnSchema(name, type, mode));
    }

    public void add(String name, TypeProtos.MinorType type) {
        this.add(name, type, TypeProtos.DataMode.REQUIRED);
    }

    public void add(String name, TypeProtos.MinorType type, int width) {
        MaterializedField field = new ColumnBuilder(name, type).setMode(TypeProtos.DataMode.REQUIRED).setWidth(width).build();
        this.add(field);
    }

    public void addNullable(String name, TypeProtos.MinorType type) {
        this.add(name, type, TypeProtos.DataMode.OPTIONAL);
    }

    public void addNullable(String name, TypeProtos.MinorType type, int width) {
        MaterializedField field = new ColumnBuilder(name, type).setMode(TypeProtos.DataMode.OPTIONAL).setWidth(width).build();
        this.add(field);
    }

    public void addArray(String name, TypeProtos.MinorType type) {
        this.add(name, type, TypeProtos.DataMode.REPEATED);
    }

    public void addDecimal(String name, TypeProtos.MinorType type, TypeProtos.DataMode mode, int precision, int scale) {
        MaterializedField field = new ColumnBuilder(name, type).setMode(mode).setPrecisionAndScale(precision, scale).build();
        this.add(field);
    }

    public void addArray(String name, TypeProtos.MinorType type, int dims) {
        assert (dims >= 1);
        if (dims == 1) {
            this.addArray(name, type);
            return;
        }
        RepeatedListBuilder listBuilder = this.addRepeatedList(this, name);
        this.buildMultiDimArray(listBuilder, type, dims - 1);
        listBuilder.build();
    }

    private void buildMultiDimArray(RepeatedListBuilder listBuilder, TypeProtos.MinorType type, int dims) {
        if (dims == 1) {
            listBuilder.addArray(type);
        } else {
            RepeatedListBuilder childBuilder = listBuilder.addDimension();
            this.buildMultiDimArray(childBuilder, type, dims - 1);
            childBuilder.build();
        }
    }

    public MapBuilder addMap(SchemaContainer parent, String name) {
        return new MapBuilder(parent, name, TypeProtos.DataMode.REQUIRED);
    }

    public MapBuilder addMapArray(SchemaContainer parent, String name) {
        return new MapBuilder(parent, name, TypeProtos.DataMode.REPEATED);
    }

    public UnionBuilder addUnion(SchemaContainer parent, String name) {
        return new UnionBuilder(parent, name, TypeProtos.MinorType.UNION);
    }

    public UnionBuilder addList(SchemaContainer parent, String name) {
        return new UnionBuilder(parent, name, TypeProtos.MinorType.LIST);
    }

    public RepeatedListBuilder addRepeatedList(SchemaContainer parent, String name) {
        return new RepeatedListBuilder(parent, name);
    }

    public TupleSchema schema() {
        return this.schema;
    }
}

