/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.metadata;

import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.MapBuilder;
import oadd.org.apache.drill.exec.record.metadata.MetadataUtils;
import oadd.org.apache.drill.exec.record.metadata.RepeatedListColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.SchemaBuilder;
import oadd.org.apache.drill.exec.record.metadata.SchemaContainer;
import oadd.org.apache.drill.exec.record.metadata.UnionBuilder;

public class RepeatedListBuilder
implements SchemaContainer {
    private final SchemaContainer parent;
    private final String name;
    private ColumnMetadata child;

    public RepeatedListBuilder(String name) {
        this(null, name);
    }

    public RepeatedListBuilder(SchemaContainer parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public RepeatedListBuilder addDimension() {
        return new RepeatedListBuilder(this, this.name);
    }

    public MapBuilder addMapArray() {
        return new MapBuilder(this, this.name, TypeProtos.DataMode.REPEATED);
    }

    public RepeatedListBuilder addArray(TypeProtos.MinorType type) {
        this.addColumn(MetadataUtils.newScalar(this.name, type, TypeProtos.DataMode.REPEATED));
        return this;
    }

    public RepeatedListBuilder addArray(TypeProtos.MinorType type, int width) {
        TypeProtos.MajorType majorType = TypeProtos.MajorType.newBuilder().setMinorType(type).setMode(TypeProtos.DataMode.REPEATED).setPrecision(width).build();
        this.addColumn(MetadataUtils.newScalar(this.name, majorType));
        return this;
    }

    public RepeatedListBuilder addArray(TypeProtos.MinorType type, int precision, int scale) {
        TypeProtos.MajorType majorType = TypeProtos.MajorType.newBuilder().setMinorType(type).setMode(TypeProtos.DataMode.REPEATED).setPrecision(precision).setScale(scale).build();
        this.addColumn(MetadataUtils.newScalar(this.name, majorType));
        return this;
    }

    public RepeatedListColumnMetadata buildColumn() {
        return MetadataUtils.newRepeatedList(this.name, this.child);
    }

    public void build() {
        if (this.parent != null) {
            this.parent.addColumn(this.buildColumn());
        }
    }

    public RepeatedListBuilder resumeList() {
        this.build();
        return (RepeatedListBuilder)this.parent;
    }

    public SchemaBuilder resumeSchema() {
        this.build();
        return (SchemaBuilder)this.parent;
    }

    public UnionBuilder resumeUnion() {
        this.build();
        return (UnionBuilder)this.parent;
    }

    public MapBuilder resumeMap() {
        this.build();
        return (MapBuilder)this.parent;
    }

    @Override
    public void addColumn(ColumnMetadata column) {
        assert (this.child == null);
        this.child = column;
    }
}

