/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.metadata;

import oadd.org.apache.drill.exec.record.metadata.Propertied;

public class PropertyAccessor {
    private PropertyAccessor() {
    }

    public static String getString(Propertied props, String key, String defaultValue) {
        String value = props.property(key);
        return value == null ? defaultValue : value;
    }

    public static int getInt(Propertied props, String key, int defaultValue) {
        String value = props.property(key);
        try {
            return value == null ? defaultValue : Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(String.format("Invalid int property %s: %s", key, value), e);
        }
    }

    public static int getInt(Propertied props, String key) {
        return PropertyAccessor.getInt(props, key, 0);
    }

    public static boolean getBoolean(Propertied props, String key, boolean defaultValue) {
        String value = props.property(key);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    public static boolean getBoolean(Propertied props, String key) {
        return PropertyAccessor.getBoolean(props, key, false);
    }

    public static void set(Propertied props, String key, int value) {
        props.setProperty(key, Integer.toString(value));
    }

    public static void set(Propertied props, String key, boolean value) {
        props.setProperty(key, Boolean.toString(value));
    }
}

