/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import java.util.concurrent.atomic.AtomicBoolean;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.proto.BitData;
import oadd.org.apache.drill.exec.rpc.data.AckSender;

public class RawFragmentBatch {
    private final BitData.FragmentRecordBatch header;
    private final DrillBuf body;
    private final AckSender sender;
    private final AtomicBoolean ackSent = new AtomicBoolean(false);

    public RawFragmentBatch(BitData.FragmentRecordBatch header, DrillBuf body, AckSender sender) {
        this.header = header;
        this.sender = sender;
        this.body = body;
        if (body != null) {
            body.retain(1);
        }
    }

    public BitData.FragmentRecordBatch getHeader() {
        return this.header;
    }

    public DrillBuf getBody() {
        return this.body;
    }

    public String toString() {
        return "RawFragmentBatch [header=" + this.header + ", body=" + this.body + "]";
    }

    public void release() {
        if (this.body != null) {
            this.body.release(1);
        }
    }

    public AckSender getSender() {
        return this.sender;
    }

    public synchronized void sendOk() {
        if (this.sender != null && this.ackSent.compareAndSet(false, true)) {
            this.sender.sendOk();
        }
    }

    public long getByteCount() {
        return this.body == null ? 0L : (long)this.body.readableBytes();
    }

    public boolean isAckSent() {
        return this.ackSent.get();
    }
}

