/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.ops;

import java.util.LinkedHashMap;
import java.util.Map;
import oadd.org.apache.commons.lang3.tuple.ImmutablePair;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.ops.OpProfileDef;
import oadd.org.apache.drill.exec.ops.OperatorStats;
import oadd.org.apache.drill.exec.proto.CoordinationProtos;
import oadd.org.apache.drill.exec.proto.UserBitShared;

public class FragmentStats {
    private Map<ImmutablePair<Integer, Integer>, OperatorStats> operators = new LinkedHashMap<ImmutablePair<Integer, Integer>, OperatorStats>();
    private final long startTime = System.currentTimeMillis();
    private final CoordinationProtos.DrillbitEndpoint endpoint;
    private final BufferAllocator allocator;

    public FragmentStats(BufferAllocator allocator, CoordinationProtos.DrillbitEndpoint endpoint) {
        this.endpoint = endpoint;
        this.allocator = allocator;
    }

    public void addMetricsToStatus(UserBitShared.MinorFragmentProfile.Builder prfB) {
        prfB.setStartTime(this.startTime);
        prfB.setMaxMemoryUsed(this.allocator.getPeakMemoryAllocation());
        prfB.setEndTime(System.currentTimeMillis());
        prfB.setEndpoint(this.endpoint);
        for (Map.Entry<ImmutablePair<Integer, Integer>, OperatorStats> o : this.operators.entrySet()) {
            prfB.addOperatorProfile(o.getValue().getProfile());
        }
    }

    public OperatorStats newOperatorStats(OpProfileDef profileDef, BufferAllocator allocator) {
        OperatorStats stats = new OperatorStats(profileDef, allocator);
        if (profileDef.operatorType != -1) {
            OperatorStats operatorStats = this.addOperatorStats(stats);
        }
        return stats;
    }

    public OperatorStats addOperatorStats(OperatorStats stats) {
        return this.operators.put(new ImmutablePair<Integer, Integer>(stats.operatorId, stats.operatorType), stats);
    }
}

