/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.metastore;

import java.io.IOException;
import oadd.org.apache.drill.exec.metastore.MetadataProviderManager;
import oadd.org.apache.drill.exec.metastore.SimpleFileTableMetadataProvider;
import oadd.org.apache.drill.exec.planner.common.DrillStatsTable;
import oadd.org.apache.drill.exec.record.metadata.TupleMetadata;
import oadd.org.apache.drill.exec.record.metadata.schema.SchemaProvider;
import oadd.org.apache.drill.exec.store.parquet.ParquetTableMetadataProviderImpl;
import org.apache.drill.metastore.metadata.TableMetadataProvider;
import org.apache.drill.metastore.metadata.TableMetadataProviderBuilder;

public class FileSystemMetadataProviderManager
implements MetadataProviderManager {
    private SchemaProvider schemaProvider;
    private DrillStatsTable statsProvider;
    private TableMetadataProvider tableMetadataProvider;

    public static MetadataProviderManager init() {
        return new FileSystemMetadataProviderManager();
    }

    public static TableMetadataProvider getMetadataProviderForSchema(TupleMetadata schema) throws IOException {
        return new FileSystemMetadataProviderManager().builder(MetadataProviderManager.MetadataProviderKind.SCHEMA_STATS_ONLY).withSchema(schema).build();
    }

    public static TableMetadataProvider getMetadataProvider(MetadataProviderManager providerManager) throws IOException {
        return providerManager == null ? new FileSystemMetadataProviderManager().builder(MetadataProviderManager.MetadataProviderKind.SCHEMA_STATS_ONLY).build() : providerManager.getTableMetadataProvider();
    }

    @Override
    public void setSchemaProvider(SchemaProvider schemaProvider) {
        this.schemaProvider = schemaProvider;
    }

    @Override
    public SchemaProvider getSchemaProvider() {
        return this.schemaProvider;
    }

    @Override
    public void setStatsProvider(DrillStatsTable statsProvider) {
        this.statsProvider = statsProvider;
    }

    @Override
    public DrillStatsTable getStatsProvider() {
        return this.statsProvider;
    }

    @Override
    public void setTableMetadataProvider(TableMetadataProvider tableMetadataProvider) {
        this.tableMetadataProvider = tableMetadataProvider;
    }

    @Override
    public TableMetadataProvider getTableMetadataProvider() {
        return this.tableMetadataProvider;
    }

    @Override
    public TableMetadataProviderBuilder builder(MetadataProviderManager.MetadataProviderKind kind) {
        switch (kind) {
            case PARQUET_TABLE: {
                return new ParquetTableMetadataProviderImpl.Builder((MetadataProviderManager)this);
            }
            case SCHEMA_STATS_ONLY: {
                return new SimpleFileTableMetadataProvider.Builder(this);
            }
        }
        return null;
    }
}

