/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.expr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.BiFunction;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.LogicalExpressionBase;
import oadd.org.apache.drill.common.expression.TypedFieldExpr;
import oadd.org.apache.drill.common.expression.visitors.ExprVisitor;
import oadd.org.apache.drill.exec.expr.FilterPredicate;
import oadd.org.apache.drill.exec.expr.StatisticsProvider;
import oadd.org.apache.drill.exec.expr.stat.RowsMatch;
import org.apache.drill.metastore.statistics.ColumnStatistics;
import org.apache.drill.metastore.statistics.ColumnStatisticsKind;
import org.apache.drill.metastore.statistics.StatisticsKind;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class IsPredicate<C extends Comparable<C>>
extends LogicalExpressionBase
implements FilterPredicate<C> {
    private final LogicalExpression expr;
    private final BiFunction<ColumnStatistics<C>, StatisticsProvider<C>, RowsMatch> predicate;

    private IsPredicate(LogicalExpression expr, BiFunction<ColumnStatistics<C>, StatisticsProvider<C>, RowsMatch> predicate) {
        super(expr.getPosition());
        this.expr = expr;
        this.predicate = predicate;
    }

    @Override
    public Iterator<LogicalExpression> iterator() {
        ArrayList<LogicalExpression> args = new ArrayList<LogicalExpression>();
        args.add(this.expr);
        return args.iterator();
    }

    @Override
    public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
        return visitor.visitUnknown(this, value);
    }

    @Override
    public RowsMatch matches(StatisticsProvider<C> evaluator) {
        ColumnStatistics exprStat = (ColumnStatistics)this.expr.accept(evaluator, null);
        return IsPredicate.isNullOrEmpty(exprStat) ? RowsMatch.SOME : this.predicate.apply(exprStat, evaluator);
    }

    public static boolean isNullOrEmpty(ColumnStatistics<?> stat) {
        return stat == null || !stat.contains((StatisticsKind)ColumnStatisticsKind.MIN_VALUE) || !stat.contains((StatisticsKind)ColumnStatisticsKind.MAX_VALUE) || !stat.contains((StatisticsKind)ColumnStatisticsKind.NULLS_COUNT) || (Long)ColumnStatisticsKind.NULLS_COUNT.getFrom(stat) == -1L;
    }

    private static RowsMatch checkNull(ColumnStatistics<?> exprStat) {
        return IsPredicate.hasNoNulls(exprStat) ? RowsMatch.ALL : RowsMatch.SOME;
    }

    static boolean hasNoNulls(ColumnStatistics<?> stat) {
        return (Long)ColumnStatisticsKind.NULLS_COUNT.getFrom(stat) == 0L;
    }

    private static <C extends Comparable<C>> LogicalExpression createIsNullPredicate(LogicalExpression expr) {
        return new IsPredicate<C>(expr, (exprStat, evaluator) -> {
            TypedFieldExpr typedFieldExpr;
            if (expr instanceof TypedFieldExpr && (typedFieldExpr = (TypedFieldExpr)expr).getPath().isArray()) {
                return RowsMatch.SOME;
            }
            if (IsPredicate.hasNoNulls(exprStat)) {
                return RowsMatch.NONE;
            }
            return IsPredicate.isAllNulls(exprStat, evaluator.getRowCount()) ? RowsMatch.ALL : RowsMatch.SOME;
        });
    }

    static <T> boolean isAllNulls(ColumnStatistics<T> stat, long rowCount) {
        Preconditions.checkArgument(rowCount >= 0L, "negative rowCount %d is not valid", rowCount);
        return (Long)ColumnStatisticsKind.NULLS_COUNT.getFrom(stat) >= rowCount && ColumnStatisticsKind.MIN_VALUE.getValueStatistic(stat) == null && ColumnStatisticsKind.MAX_VALUE.getValueStatistic(stat) == null;
    }

    static <T> boolean hasNonNullValues(ColumnStatistics<T> stat, long rowCount) {
        return rowCount > (Long)ColumnStatisticsKind.NULLS_COUNT.getFrom(stat) && ColumnStatisticsKind.MIN_VALUE.getValueStatistic(stat) != null && ColumnStatisticsKind.MAX_VALUE.getValueStatistic(stat) != null;
    }

    private static <C extends Comparable<C>> LogicalExpression createIsNotNullPredicate(LogicalExpression expr) {
        return new IsPredicate<C>(expr, (exprStat, evaluator) -> IsPredicate.isAllNulls(exprStat, evaluator.getRowCount()) ? RowsMatch.NONE : IsPredicate.checkNull(exprStat));
    }

    private static LogicalExpression createIsTruePredicate(LogicalExpression expr) {
        return new IsPredicate(expr, (exprStat, evaluator) -> {
            if (IsPredicate.isAllNulls(exprStat, evaluator.getRowCount())) {
                return RowsMatch.NONE;
            }
            if (!IsPredicate.hasNonNullValues(exprStat, evaluator.getRowCount())) {
                return RowsMatch.SOME;
            }
            if (!((Boolean)ColumnStatisticsKind.MAX_VALUE.getValueStatistic(exprStat)).booleanValue()) {
                return RowsMatch.NONE;
            }
            return (Boolean)ColumnStatisticsKind.MIN_VALUE.getValueStatistic(exprStat) != false ? IsPredicate.checkNull(exprStat) : RowsMatch.SOME;
        });
    }

    private static LogicalExpression createIsFalsePredicate(LogicalExpression expr) {
        return new IsPredicate(expr, (exprStat, evaluator) -> {
            if (IsPredicate.isAllNulls(exprStat, evaluator.getRowCount())) {
                return RowsMatch.NONE;
            }
            if (!IsPredicate.hasNonNullValues(exprStat, evaluator.getRowCount())) {
                return RowsMatch.SOME;
            }
            if (((Boolean)ColumnStatisticsKind.MIN_VALUE.getValueStatistic(exprStat)).booleanValue()) {
                return RowsMatch.NONE;
            }
            return (Boolean)ColumnStatisticsKind.MAX_VALUE.getValueStatistic(exprStat) != false ? RowsMatch.SOME : IsPredicate.checkNull(exprStat);
        });
    }

    private static LogicalExpression createIsNotTruePredicate(LogicalExpression expr) {
        return new IsPredicate(expr, (exprStat, evaluator) -> {
            if (IsPredicate.isAllNulls(exprStat, evaluator.getRowCount())) {
                return RowsMatch.ALL;
            }
            if (!IsPredicate.hasNonNullValues(exprStat, evaluator.getRowCount())) {
                return RowsMatch.SOME;
            }
            if (((Boolean)ColumnStatisticsKind.MIN_VALUE.getValueStatistic(exprStat)).booleanValue()) {
                return IsPredicate.hasNoNulls(exprStat) ? RowsMatch.NONE : RowsMatch.SOME;
            }
            return (Boolean)ColumnStatisticsKind.MAX_VALUE.getValueStatistic(exprStat) != false ? RowsMatch.SOME : RowsMatch.ALL;
        });
    }

    private static LogicalExpression createIsNotFalsePredicate(LogicalExpression expr) {
        return new IsPredicate(expr, (exprStat, evaluator) -> {
            if (IsPredicate.isAllNulls(exprStat, evaluator.getRowCount())) {
                return RowsMatch.ALL;
            }
            if (!IsPredicate.hasNonNullValues(exprStat, evaluator.getRowCount())) {
                return RowsMatch.SOME;
            }
            if (!((Boolean)ColumnStatisticsKind.MAX_VALUE.getValueStatistic(exprStat)).booleanValue()) {
                return IsPredicate.hasNoNulls(exprStat) ? RowsMatch.NONE : RowsMatch.SOME;
            }
            return (Boolean)ColumnStatisticsKind.MIN_VALUE.getValueStatistic(exprStat) != false ? RowsMatch.ALL : RowsMatch.SOME;
        });
    }

    public static <C extends Comparable<C>> LogicalExpression createIsPredicate(String function, LogicalExpression expr) {
        switch (function) {
            case "isnull": {
                return IsPredicate.createIsNullPredicate(expr);
            }
            case "isnotnull": {
                return IsPredicate.createIsNotNullPredicate(expr);
            }
            case "istrue": {
                return IsPredicate.createIsTruePredicate(expr);
            }
            case "isnottrue": {
                return IsPredicate.createIsNotTruePredicate(expr);
            }
            case "isfalse": 
            case "not": {
                return IsPredicate.createIsFalsePredicate(expr);
            }
            case "isnotfalse": {
                return IsPredicate.createIsNotFalsePredicate(expr);
            }
        }
        logger.warn("Unhandled IS function. Function name: {}", (Object)function);
        return null;
    }
}

