/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.cache;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.TimeUnit;
import oadd.com.codahale.metrics.MetricRegistry;
import oadd.com.codahale.metrics.Timer;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.cache.VectorAccessibleSerializable;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.metrics.DrillMetrics;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.VectorAccessible;
import oadd.org.apache.drill.exec.record.VectorContainer;
import oadd.org.apache.drill.exec.record.WritableBatch;
import oadd.org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class VectorSerializer {
    public static Writer writer(WritableByteChannel channel) throws IOException {
        return new Writer(channel);
    }

    public static Reader reader(BufferAllocator allocator, InputStream stream) {
        return new Reader(allocator, stream);
    }

    public static class Reader {
        private final InputStream stream;
        private long timeNs;
        private final VectorAccessibleSerializable vas;

        public Reader(BufferAllocator allocator, InputStream stream) {
            this.stream = stream;
            this.vas = new VectorAccessibleSerializable(allocator);
        }

        public VectorContainer read() throws IOException {
            this.vas.readFromStream(this.stream);
            this.timeNs = this.vas.getTimeNs();
            return this.vas.get();
        }

        public SelectionVector2 sv2() {
            return this.vas.getSv2();
        }

        public long timeNs() {
            return this.timeNs;
        }
    }

    public static class Writer
    implements Closeable {
        static final MetricRegistry metrics = DrillMetrics.getRegistry();
        static final String WRITER_TIMER = MetricRegistry.name(VectorAccessibleSerializable.class, "writerTime");
        private final WritableByteChannel channel;
        private final OutputStream output;
        private long timeNs;
        private int bytesWritten;

        private Writer(WritableByteChannel channel) {
            this.channel = channel;
            this.output = Channels.newOutputStream(channel);
        }

        public int write(VectorAccessible va) throws IOException {
            return this.write(va, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int write(VectorAccessible va, SelectionVector2 sv2) throws IOException {
            Preconditions.checkNotNull(va);
            WritableBatch batch = WritableBatch.getBatchNoHVWrap(va.getRecordCount(), va, sv2 != null);
            try {
                int n = this.write(batch, sv2);
                return n;
            }
            finally {
                batch.clear();
            }
        }

        public int write(WritableBatch batch, SelectionVector2 sv2) throws IOException {
            Preconditions.checkNotNull(batch);
            Preconditions.checkNotNull(this.channel);
            Timer.Context timerContext = metrics.timer(WRITER_TIMER).time();
            DrillBuf[] incomingBuffers = batch.getBuffers();
            UserBitShared.RecordBatchDef batchDef = batch.getDef();
            int bytesWritten = batchDef.getSerializedSize();
            batchDef.writeDelimitedTo(this.output);
            if (sv2 != null) {
                int dataLength = sv2.getCount() * 2;
                ByteBuffer buffer = sv2.getBuffer(false).nioBuffer(0, dataLength);
                while (buffer.remaining() > 0) {
                    bytesWritten += this.channel.write(buffer);
                }
            }
            for (DrillBuf buf : incomingBuffers) {
                ByteBuffer buffer = buf.nioBuffer();
                while (buffer.remaining() > 0) {
                    bytesWritten += this.channel.write(buffer);
                }
            }
            this.timeNs += timerContext.stop();
            this.bytesWritten += bytesWritten;
            return bytesWritten;
        }

        @Override
        public void close() throws IOException {
            if (!this.channel.isOpen()) {
                return;
            }
            this.channel.close();
        }

        public long time(TimeUnit unit) {
            return unit.convert(this.timeNs, TimeUnit.NANOSECONDS);
        }

        public int getBytesWritten() {
            return this.bytesWritten;
        }
    }
}

