/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.util;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import oadd.javassist.ClassPool;
import oadd.javassist.CtClass;
import oadd.javassist.CtConstructor;
import oadd.javassist.CtMethod;
import oadd.javassist.CtNewMethod;
import oadd.javassist.scopedpool.ScopedClassPoolRepository;
import oadd.javassist.scopedpool.ScopedClassPoolRepositoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaPatcher {
    private static final Logger logger = LoggerFactory.getLogger(GuavaPatcher.class);
    private static boolean patchingAttempted;

    public static synchronized void patch() {
        if (!patchingAttempted) {
            patchingAttempted = true;
            GuavaPatcher.patchStopwatch();
            GuavaPatcher.patchCloseables();
            GuavaPatcher.patchPreconditions();
        }
    }

    private static void patchStopwatch() {
        try {
            ClassPool cp = GuavaPatcher.getClassPool();
            CtClass cc = cp.get("oadd.com.google.common.base.Stopwatch");
            for (CtConstructor c : cc.getConstructors()) {
                if (Modifier.isStatic(c.getModifiers())) continue;
                c.setModifiers(1);
            }
            CtMethod newMethod = CtNewMethod.make("public long elapsedMillis() { return elapsed(java.util.concurrent.TimeUnit.MILLISECONDS); }", cc);
            cc.addMethod(newMethod);
            cc.toClass();
            logger.info("Google's Stopwatch patched for old HBase Guava version.");
        }
        catch (Exception e) {
            logger.warn("Unable to patch Guava classes.", e);
        }
    }

    private static void patchCloseables() {
        try {
            ClassPool cp = GuavaPatcher.getClassPool();
            CtClass cc = cp.get("oadd.com.google.common.io.Closeables");
            CtMethod newMethod = CtNewMethod.make("public static void closeQuietly(java.io.Closeable closeable) { try{closeable.close();}catch(Exception e){} }", cc);
            cc.addMethod(newMethod);
            cc.toClass();
            logger.info("Google's Closeables patched for old HBase Guava version.");
        }
        catch (Exception e) {
            logger.warn("Unable to patch Guava classes.", e);
        }
    }

    private static void patchPreconditions() {
        try {
            ClassPool cp = GuavaPatcher.getClassPool();
            CtClass cc = cp.get("oadd.com.google.common.base.Preconditions");
            int startIndex = 1;
            int endIndex = 5;
            List<String> methodsWithVarargsTemplates = Arrays.asList("public static void checkArgument(boolean expression, String errorMessageTemplate, %s) {\n    if (!expression) {\n      throw new IllegalArgumentException(format(errorMessageTemplate, new Object[] { %s }));\n    }\n  }", "public static Object checkNotNull(Object reference, String errorMessageTemplate, %s) {\n    if (reference == null) {\n      throw new NullPointerException(format(errorMessageTemplate, new Object[] { %s }));\n    } else {\n      return reference;\n    }\n  }", "public static void checkState(boolean expression, String errorMessageTemplate, %s) {\n    if (!expression) {\n      throw new IllegalStateException(format(errorMessageTemplate, new Object[] { %s }));\n    }\n  }");
            List<String> methodsWithPrimitives = Arrays.asList("public static void checkArgument(boolean expression, String errorMessageTemplate, int arg1) {\n    if (!expression) {\n      throw new IllegalArgumentException(format(errorMessageTemplate, new Object[] { new Integer(arg1) }));\n    }\n  }", "public static void checkArgument(boolean expression, String errorMessageTemplate, long arg1) {\n    if (!expression) {\n      throw new IllegalArgumentException(format(errorMessageTemplate, new Object[] { new Long(arg1) }));\n    }\n  }", "public static void checkArgument(boolean expression, String errorMessageTemplate, long arg1, long arg2) {\n    if (!expression) {\n      throw new IllegalArgumentException(format(errorMessageTemplate, new Object[] { new Long(arg1), new Long(arg2)}));\n    }\n  }", "public static Object checkNotNull(Object reference, String errorMessageTemplate, int arg1) {\n    if (reference == null) {\n      throw new NullPointerException(format(errorMessageTemplate, new Object[] { new Integer(arg1) }));\n    } else {\n      return reference;\n    }\n  }", "public static void checkState(boolean expression, String errorMessageTemplate, int arg1) {\n    if (!expression) {\n      throw new IllegalStateException(format(errorMessageTemplate, new Object[] { new Integer(arg1) }));\n    }\n  }");
            List newMethods = IntStream.rangeClosed(startIndex, endIndex).mapToObj(i -> {
                List args = IntStream.rangeClosed(startIndex, i).mapToObj(j -> "arg" + j).collect(Collectors.toList());
                String methodInput = args.stream().map(arg -> "Object " + arg).collect(Collectors.joining(", "));
                String arrayInput = String.join((CharSequence)", ", args);
                return methodsWithVarargsTemplates.stream().map(method -> String.format(method, methodInput, arrayInput)).collect(Collectors.toList());
            }).flatMap(Collection::stream).collect(Collectors.toList());
            newMethods.addAll(methodsWithPrimitives);
            for (String method : newMethods) {
                CtMethod newMethod = CtNewMethod.make(method, cc);
                cc.addMethod(newMethod);
            }
            cc.toClass();
            logger.info("Google's Preconditions were patched to hold new methods.");
        }
        catch (Exception e) {
            logger.warn("Unable to patch Guava classes.", e);
        }
    }

    private static ClassPool getClassPool() {
        ScopedClassPoolRepository classPoolRepository = ScopedClassPoolRepositoryImpl.getInstance();
        classPoolRepository.setPrune(false);
        return classPoolRepository.createScopedClassPool(GuavaPatcher.class.getClassLoader(), null);
    }
}

