/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.scanner.persistence;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oadd.com.fasterxml.jackson.annotation.JsonCreator;
import oadd.com.fasterxml.jackson.annotation.JsonProperty;
import oadd.org.apache.drill.common.scanner.persistence.AttributeDescriptor;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;

public final class AnnotationDescriptor {
    private final String annotationType;
    private final List<AttributeDescriptor> attributes;
    private final Map<String, AttributeDescriptor> attributeMap;

    @JsonCreator
    public AnnotationDescriptor(@JsonProperty(value="annotationType") String annotationType, @JsonProperty(value="attributes") List<AttributeDescriptor> attributes) {
        this.annotationType = annotationType;
        this.attributes = Collections.unmodifiableList(attributes);
        ImmutableMap.Builder<String, AttributeDescriptor> mapBuilder = ImmutableMap.builder();
        for (AttributeDescriptor att : attributes) {
            mapBuilder.put(att.getName(), att);
        }
        this.attributeMap = mapBuilder.build();
    }

    public String getAnnotationType() {
        return this.annotationType;
    }

    public List<AttributeDescriptor> getAttributes() {
        return this.attributes;
    }

    public boolean hasAttribute(String attributeName) {
        return this.attributeMap.containsKey(attributeName);
    }

    public List<String> getValues(String attributeName) {
        AttributeDescriptor desc = this.attributeMap.get(attributeName);
        return desc == null ? Collections.emptyList() : desc.getValues();
    }

    public String getSingleValue(String attributeName, String defaultValue) {
        List<String> values = this.getValues(attributeName);
        if (values.size() > 1) {
            throw new IllegalStateException(String.format("Expected a single value for the attribute named %s but found %d (%s)", attributeName, values.size(), values.toString()));
        }
        return values.isEmpty() ? defaultValue : values.get(0);
    }

    public String getSingleValue(String attributeName) {
        String val = this.getSingleValue(attributeName, null);
        if (val == null) {
            throw new IllegalStateException(String.format("Attribute %s not found in %s", attributeName, this.attributes));
        }
        return val;
    }

    public String toString() {
        return "Annotation[type=" + this.annotationType + ", attributes=" + this.attributes + "]";
    }

    static Map<String, AnnotationDescriptor> buildAnnotationsMap(List<AnnotationDescriptor> annotations) {
        ImmutableMap.Builder<String, AnnotationDescriptor> annMapBuilder = ImmutableMap.builder();
        for (AnnotationDescriptor ann : annotations) {
            annMapBuilder.put(ann.getAnnotationType(), ann);
        }
        return annMapBuilder.build();
    }

    private <T> T proxy(Class<T> interfc, InvocationHandler ih) {
        if (!interfc.isInterface()) {
            throw new IllegalArgumentException("only proxying interfaces: " + interfc);
        }
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{interfc}, ih);
    }

    public <T> T getProxy(Class<T> clazz) {
        return this.proxy(clazz, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (args != null && args.length > 0) {
                    throw new UnsupportedOperationException(method + " " + Arrays.toString(args));
                }
                String attributeName = method.getName();
                if (!AnnotationDescriptor.this.hasAttribute(attributeName)) {
                    return method.getDefaultValue();
                }
                Class<?> returnType = method.getReturnType();
                if (returnType.isArray()) {
                    List<String> values = AnnotationDescriptor.this.getValues(attributeName);
                    Class<?> componentType = returnType.getComponentType();
                    Object[] result = (Object[])Array.newInstance(componentType, values.size());
                    for (int i = 0; i < result.length; ++i) {
                        String value = values.get(i);
                        result[i] = this.convertValue(componentType, value);
                    }
                    return result;
                }
                String value = AnnotationDescriptor.this.getSingleValue(attributeName, null);
                return this.convertValue(returnType, value);
            }

            private <U> Object convertValue(Class<U> c, String value) {
                if (c.equals(String.class)) {
                    return value;
                }
                if (c.isEnum()) {
                    Enum enumValue = Enum.valueOf(c.asSubclass(Enum.class), value);
                    return enumValue;
                }
                if (c.equals(Boolean.TYPE)) {
                    return Boolean.valueOf(value);
                }
                if (c.equals(Integer.TYPE)) {
                    return Integer.valueOf(value);
                }
                throw new UnsupportedOperationException(c.toString());
            }
        });
    }
}

