/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.logical;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oadd.com.fasterxml.jackson.annotation.JsonCreator;
import oadd.com.fasterxml.jackson.annotation.JsonIgnore;
import oadd.com.fasterxml.jackson.annotation.JsonProperty;
import oadd.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import oadd.com.fasterxml.jackson.core.JsonProcessingException;
import oadd.com.fasterxml.jackson.databind.ObjectMapper;
import oadd.org.apache.drill.common.config.LogicalPlanPersistence;
import oadd.org.apache.drill.common.graph.Graph;
import oadd.org.apache.drill.common.graph.GraphAlgos;
import oadd.org.apache.drill.common.logical.LogicalPlanBuilder;
import oadd.org.apache.drill.common.logical.PlanProperties;
import oadd.org.apache.drill.common.logical.StoragePluginConfig;
import oadd.org.apache.drill.common.logical.data.LogicalOperator;
import oadd.org.apache.drill.common.logical.data.SinkOperator;
import oadd.org.apache.drill.common.logical.data.SourceOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonPropertyOrder(value={"head", "storage", "query"})
public class LogicalPlan {
    static final Logger logger = LoggerFactory.getLogger(LogicalPlan.class);
    private final PlanProperties properties;
    private final Map<String, StoragePluginConfig> storageEngineMap;
    private final Graph<LogicalOperator, SinkOperator, SourceOperator> graph;

    @JsonCreator
    public LogicalPlan(@JsonProperty(value="head") PlanProperties head, @JsonProperty(value="storage") Map<String, StoragePluginConfig> storageEngineMap, @JsonProperty(value="query") List<LogicalOperator> operators) {
        this.storageEngineMap = storageEngineMap != null ? storageEngineMap : new HashMap();
        this.properties = head;
        this.graph = Graph.newGraph(operators, SinkOperator.class, SourceOperator.class);
    }

    @JsonProperty(value="query")
    public List<LogicalOperator> getSortedOperators() {
        return GraphAlgos.TopoSorter.sortLogical(this.graph);
    }

    public StoragePluginConfig getStorageEngineConfig(String name) {
        return this.storageEngineMap.get(name);
    }

    @JsonIgnore
    public Graph<LogicalOperator, SinkOperator, SourceOperator> getGraph() {
        return this.graph;
    }

    @JsonProperty(value="head")
    public PlanProperties getProperties() {
        return this.properties;
    }

    @JsonProperty(value="storage")
    public Map<String, StoragePluginConfig> getStorageEngines() {
        return this.storageEngineMap;
    }

    public String toJsonString(LogicalPlanPersistence config) throws JsonProcessingException {
        return config.getMapper().writeValueAsString(this);
    }

    public String toJsonStringSafe(LogicalPlanPersistence config) {
        try {
            return this.toJsonString(config);
        }
        catch (JsonProcessingException e) {
            logger.error("Failure while trying to get JSON representation of plan.", e);
            return "Unable to generate plan.";
        }
    }

    public static LogicalPlan parse(LogicalPlanPersistence config, String planString) {
        ObjectMapper mapper = config.getMapper();
        try {
            LogicalPlan plan = mapper.readValue(planString, LogicalPlan.class);
            return plan;
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failure while parsing plan: \n %s}", planString), e);
        }
    }

    public String unparse(LogicalPlanPersistence config) {
        try {
            return config.getMapper().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static LogicalPlanBuilder builder() {
        return new LogicalPlanBuilder();
    }
}

