/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.google.common.collect;

import java.util.Collections;
import java.util.Queue;
import oadd.com.google.common.annotations.GwtCompatible;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.AbstractIterator;
import oadd.com.google.common.collect.Lists;

@GwtCompatible
class ConsumingQueueIterator<T>
extends AbstractIterator<T> {
    private final Queue<T> queue;

    ConsumingQueueIterator(T ... elements) {
        this.queue = Lists.newLinkedList();
        Collections.addAll(this.queue, elements);
    }

    ConsumingQueueIterator(Queue<T> queue) {
        this.queue = Preconditions.checkNotNull(queue);
    }

    @Override
    public T computeNext() {
        return this.queue.isEmpty() ? this.endOfData() : this.queue.remove();
    }
}

