/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.codahale.metrics.servlets;

import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ExecutorService;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oadd.com.codahale.metrics.health.HealthCheck;
import oadd.com.codahale.metrics.health.HealthCheckFilter;
import oadd.com.codahale.metrics.health.HealthCheckRegistry;
import oadd.com.codahale.metrics.json.HealthCheckModule;
import oadd.com.fasterxml.jackson.databind.ObjectMapper;
import oadd.com.fasterxml.jackson.databind.ObjectWriter;

public class HealthCheckServlet
extends HttpServlet {
    public static final String HEALTH_CHECK_REGISTRY = HealthCheckServlet.class.getCanonicalName() + ".registry";
    public static final String HEALTH_CHECK_EXECUTOR = HealthCheckServlet.class.getCanonicalName() + ".executor";
    public static final String HEALTH_CHECK_FILTER = HealthCheckServlet.class.getCanonicalName() + ".healthCheckFilter";
    private static final long serialVersionUID = -8432996484889177321L;
    private static final String CONTENT_TYPE = "application/json";
    private transient HealthCheckRegistry registry;
    private transient ExecutorService executorService;
    private transient HealthCheckFilter filter;
    private transient ObjectMapper mapper;

    public HealthCheckServlet() {
    }

    public HealthCheckServlet(HealthCheckRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        Object filterAttr;
        Object executorAttr;
        super.init(config);
        ServletContext context = config.getServletContext();
        if (null == this.registry) {
            Object registryAttr = context.getAttribute(HEALTH_CHECK_REGISTRY);
            if (registryAttr instanceof HealthCheckRegistry) {
                this.registry = (HealthCheckRegistry)registryAttr;
            } else {
                throw new ServletException("Couldn't find a HealthCheckRegistry instance.");
            }
        }
        if ((executorAttr = context.getAttribute(HEALTH_CHECK_EXECUTOR)) instanceof ExecutorService) {
            this.executorService = (ExecutorService)executorAttr;
        }
        if ((filterAttr = context.getAttribute(HEALTH_CHECK_FILTER)) instanceof HealthCheckFilter) {
            this.filter = (HealthCheckFilter)filterAttr;
        }
        if (this.filter == null) {
            this.filter = HealthCheckFilter.ALL;
        }
        this.mapper = new ObjectMapper().registerModule(new HealthCheckModule());
    }

    @Override
    public void destroy() {
        super.destroy();
        this.registry.shutdown();
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        SortedMap<String, HealthCheck.Result> results = this.runHealthChecks();
        resp.setContentType(CONTENT_TYPE);
        resp.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        if (results.isEmpty()) {
            resp.setStatus(501);
        } else if (HealthCheckServlet.isAllHealthy(results)) {
            resp.setStatus(200);
        } else {
            resp.setStatus(500);
        }
        try (ServletOutputStream output = resp.getOutputStream();){
            this.getWriter(req).writeValue(output, results);
        }
    }

    private ObjectWriter getWriter(HttpServletRequest request) {
        boolean prettyPrint = Boolean.parseBoolean(request.getParameter("pretty"));
        if (prettyPrint) {
            return this.mapper.writerWithDefaultPrettyPrinter();
        }
        return this.mapper.writer();
    }

    private SortedMap<String, HealthCheck.Result> runHealthChecks() {
        if (this.executorService == null) {
            return this.registry.runHealthChecks(this.filter);
        }
        return this.registry.runHealthChecks(this.executorService, this.filter);
    }

    private static boolean isAllHealthy(Map<String, HealthCheck.Result> results) {
        for (HealthCheck.Result result : results.values()) {
            if (result.isHealthy()) continue;
            return false;
        }
        return true;
    }

    public static abstract class ContextListener
    implements ServletContextListener {
        protected abstract HealthCheckRegistry getHealthCheckRegistry();

        protected ExecutorService getExecutorService() {
            return null;
        }

        protected HealthCheckFilter getHealthCheckFilter() {
            return HealthCheckFilter.ALL;
        }

        @Override
        public void contextInitialized(ServletContextEvent event) {
            ServletContext context = event.getServletContext();
            context.setAttribute(HEALTH_CHECK_REGISTRY, this.getHealthCheckRegistry());
            context.setAttribute(HEALTH_CHECK_EXECUTOR, this.getExecutorService());
        }

        @Override
        public void contextDestroyed(ServletContextEvent event) {
        }
    }
}

