/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.executor;

import lombok.Generated;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.server.worker.config.WorkerConfig;
import org.apache.dolphinscheduler.server.worker.executor.PhysicalTaskExecutor;
import org.apache.dolphinscheduler.server.worker.executor.PhysicalTaskExecutorBuilder;
import org.apache.dolphinscheduler.server.worker.executor.PhysicalTaskPluginFactory;
import org.apache.dolphinscheduler.task.executor.ITaskExecutor;
import org.apache.dolphinscheduler.task.executor.ITaskExecutorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PhysicalTaskExecutorFactory
implements ITaskExecutorFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PhysicalTaskExecutorFactory.class);
    private final WorkerConfig workerConfig;
    private final PhysicalTaskPluginFactory physicalTaskPluginFactory;
    private final StorageOperator storageOperator;

    public PhysicalTaskExecutorFactory(WorkerConfig workerConfig, PhysicalTaskPluginFactory physicalTaskPluginFactory, StorageOperator storageOperator) {
        this.workerConfig = workerConfig;
        this.physicalTaskPluginFactory = physicalTaskPluginFactory;
        this.storageOperator = storageOperator;
    }

    public ITaskExecutor createTaskExecutor(TaskExecutionContext taskExecutionContext) {
        this.assemblyTaskLogPath(taskExecutionContext);
        PhysicalTaskExecutorBuilder physicalTaskExecutorBuilder = PhysicalTaskExecutorBuilder.builder().taskExecutionContext(taskExecutionContext).workerConfig(this.workerConfig).storageOperator(this.storageOperator).physicalTaskPluginFactory(this.physicalTaskPluginFactory).build();
        return new PhysicalTaskExecutor(physicalTaskExecutorBuilder);
    }

    private void assemblyTaskLogPath(TaskExecutionContext taskExecutionContext) {
        taskExecutionContext.setLogPath(LogUtils.getTaskInstanceLogFullPath((TaskExecutionContext)taskExecutionContext));
    }
}

