/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.tools.demo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.ConditionType;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.TimeoutFlag;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionTypeEnum;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.EncryptionUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.AccessToken;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.TaskDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.WorkflowTaskRelationLog;
import org.apache.dolphinscheduler.dao.mapper.AccessTokenMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.apache.dolphinscheduler.tools.demo.CreateDemoTenant;
import org.apache.dolphinscheduler.tools.demo.ProxyProcessDefinitionController;
import org.apache.dolphinscheduler.tools.demo.ProxyResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ProcessDefinitionDemo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessDefinitionDemo.class);
    @Value(value="${demo.tenant-code}")
    private String tenantCode;
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private AccessTokenMapper accessTokenMapper;
    @Autowired
    private ProxyProcessDefinitionController proxyProcessDefinitionController;

    public void createProcessDefinitionDemo() throws Exception {
        User loginUser = (User)this.userMapper.selectById((Serializable)((Object)"1"));
        Date now = new Date();
        CreateDemoTenant createDemoTenant = new CreateDemoTenant();
        createDemoTenant.createTenantCode(this.tenantCode);
        Project project = this.projectMapper.queryByName("demo");
        if (project != null) {
            log.warn("Project {} already exists.", (Object)project.getName());
        }
        try {
            project = Project.builder().name("demo").code(CodeGenerateUtils.genCode()).description("").userId(loginUser.getId()).userName(loginUser.getUserName()).createTime(now).updateTime(now).build();
        }
        catch (CodeGenerateUtils.CodeGenerateException e) {
            log.error("create project error", (Throwable)e);
        }
        if (this.projectMapper.insert((Object)project) <= 0) {
            throw new Exception("create project error");
        }
        log.info("create project success");
        Long projectCode = null;
        try {
            projectCode = project.getCode();
        }
        catch (NullPointerException e) {
            log.error("project code is null", (Throwable)e);
        }
        String expireTime = "2050-09-30 15:59:23";
        String token = EncryptionUtils.getMd5((String)(1 + expireTime + System.currentTimeMillis()));
        AccessToken accessToken = new AccessToken();
        accessToken.setUserId(1);
        accessToken.setExpireTime(DateUtils.stringToDate((String)expireTime));
        accessToken.setToken(token);
        accessToken.setCreateTime(new Date());
        accessToken.setUpdateTime(new Date());
        int insert = this.accessTokenMapper.insert((Object)accessToken);
        if (insert > 0) {
            log.info("create access token success");
        } else {
            log.info("create access token error");
        }
        ProxyResult shellResult = this.shellDemo(token, projectCode, this.tenantCode);
        log.info("create shell demo {}", (Object)shellResult.getMsg());
        LinkedHashMap subProcess = (LinkedHashMap)shellResult.getData();
        String subProcessCode = String.valueOf(subProcess.get("code"));
        ProxyResult subProcessResult = this.subProcessDemo(token, projectCode, this.tenantCode, subProcessCode);
        log.info("create subprocess demo {}", (Object)subProcessResult.getMsg());
        ProxyResult switchResult = this.swicthDemo(token, projectCode, this.tenantCode);
        log.info("create switch demo {}", (Object)switchResult.getMsg());
        ProxyResult conditionResult = this.conditionDemo(token, projectCode, this.tenantCode);
        log.info("create condition demo {}", (Object)conditionResult.getMsg());
        LinkedHashMap switchProcess = (LinkedHashMap)switchResult.getData();
        String switchProcessCode = String.valueOf(switchProcess.get("code"));
        ProxyResult dependentResult = this.dependentProxyResultDemo(token, projectCode, this.tenantCode, subProcessCode, switchProcessCode);
        log.info("create dependent demo {}", (Object)dependentResult.getMsg());
        ProxyResult parameterContextResult = this.parameterContextDemo(token, projectCode, this.tenantCode);
        log.info("create parameter context demo {}", (Object)parameterContextResult.getMsg());
        ProxyResult clearLogResult = this.clearLogDemo(token, projectCode, this.tenantCode);
        log.info("create clear log demo {}", (Object)clearLogResult.getMsg());
    }

    public ProxyResult clearLogDemo(String token, long projectCode, String tenantCode) {
        ArrayList<Long> taskCodes = new ArrayList<Long>();
        try {
            for (int i = 0; i < 1; ++i) {
                taskCodes.add(CodeGenerateUtils.genCode());
            }
        }
        catch (CodeGenerateUtils.CodeGenerateException e) {
            log.error("task code get error, ", (Throwable)e);
        }
        String taskCodeFirst = String.valueOf(taskCodes.get(0)).replaceAll("\\[|\\]", "");
        String absolutePath = System.getProperty("user.dir");
        WorkflowDefinitionLog processDefinitionLog = new WorkflowDefinitionLog();
        processDefinitionLog.setName("demo_clear_log");
        processDefinitionLog.setDescription("Clear the DS log files from 30 days ago");
        processDefinitionLog.setGlobalParams("[]");
        processDefinitionLog.setLocations(null);
        processDefinitionLog.setTimeout(0);
        ArrayList<WorkflowTaskRelationLog> processTaskRelationLogs = new ArrayList<WorkflowTaskRelationLog>();
        for (int i = 0; i < 1; ++i) {
            WorkflowTaskRelationLog processTaskRelationLog = new WorkflowTaskRelationLog();
            processTaskRelationLog.setName("");
            processTaskRelationLog.setConditionType(ConditionType.NONE);
            processTaskRelationLog.setConditionParams("{}");
            processTaskRelationLogs.add(processTaskRelationLog);
        }
        WorkflowTaskRelationLog processTaskRelationLogFirst = (WorkflowTaskRelationLog)processTaskRelationLogs.get(0);
        processTaskRelationLogFirst.setPreTaskCode(0L);
        processTaskRelationLogFirst.setPreTaskVersion(0);
        processTaskRelationLogFirst.setPostTaskCode(((Long)taskCodes.get(0)).longValue());
        processTaskRelationLogFirst.setPostTaskVersion(1);
        String taskRelationJson = JSONUtils.toJsonString(processTaskRelationLogs);
        ArrayList<TaskDefinitionLog> taskDefinitionLogs = new ArrayList<TaskDefinitionLog>();
        for (int i = 0; i < 1; ++i) {
            TaskDefinitionLog taskDefinitionLog = new TaskDefinitionLog();
            taskDefinitionLog.setFlag(Flag.YES);
            taskDefinitionLog.setDelayTime(0);
            taskDefinitionLog.setEnvironmentCode(-1L);
            taskDefinitionLog.setFailRetryInterval(1);
            taskDefinitionLog.setFailRetryTimes(0);
            taskDefinitionLog.setTaskPriority(Priority.MEDIUM);
            taskDefinitionLog.setTimeout(0);
            taskDefinitionLog.setTimeoutFlag(TimeoutFlag.CLOSE);
            taskDefinitionLog.setTimeoutNotifyStrategy(null);
            taskDefinitionLog.setWorkerGroup("default");
            taskDefinitionLog.setTaskType("SHELL");
            taskDefinitionLogs.add(taskDefinitionLog);
        }
        TaskDefinitionLog taskDefinitionLogFirst = (TaskDefinitionLog)taskDefinitionLogs.get(0);
        taskDefinitionLogFirst.setCode(((Long)taskCodes.get(0)).longValue());
        taskDefinitionLogFirst.setName("Clear log node");
        taskDefinitionLogFirst.setDescription("");
        taskDefinitionLogFirst.setTaskParams("{\"localParams\":[],\"rawScript\":\"cd cd " + absolutePath + "\\r\\nfind ./logs/ -mtime +30 -name \\\"*.log\\\" -exec rm -rf {} \\\\;\",\"resourceList\":[]}");
        String taskDefinitionJson = JSONUtils.toJsonString(taskDefinitionLogs);
        ProxyResult ProxyResult2 = this.proxyProcessDefinitionController.createProcessDefinition(token, projectCode, processDefinitionLog.getName(), processDefinitionLog.getDescription(), processDefinitionLog.getGlobalParams(), processDefinitionLog.getLocations(), processDefinitionLog.getTimeout(), tenantCode, taskRelationJson, taskDefinitionJson, WorkflowExecutionTypeEnum.PARALLEL);
        return ProxyResult2;
    }

    public ProxyResult dependentProxyResultDemo(String token, long projectCode, String tenantCode, String shellProcessCode, String switchProcessCode) {
        ArrayList<Long> taskCodes = new ArrayList<Long>();
        try {
            for (int i = 0; i < 2; ++i) {
                taskCodes.add(CodeGenerateUtils.genCode());
            }
        }
        catch (CodeGenerateUtils.CodeGenerateException e) {
            log.error("task code get error, ", (Throwable)e);
        }
        String taskCodeFirst = String.valueOf(taskCodes.get(0)).replaceAll("\\[|\\]", "");
        String taskCodeSecond = String.valueOf(taskCodes.get(1)).replaceAll("\\[|\\]", "");
        WorkflowDefinitionLog processDefinitionLog = new WorkflowDefinitionLog();
        processDefinitionLog.setName("demo_dependent");
        processDefinitionLog.setDescription("Check the completion of daily tasks");
        processDefinitionLog.setGlobalParams("[]");
        processDefinitionLog.setLocations(null);
        processDefinitionLog.setTimeout(0);
        ArrayList<WorkflowTaskRelationLog> processTaskRelationLogs = new ArrayList<WorkflowTaskRelationLog>();
        for (int i = 0; i < 2; ++i) {
            WorkflowTaskRelationLog processTaskRelationLog = new WorkflowTaskRelationLog();
            processTaskRelationLog.setName("");
            processTaskRelationLog.setConditionType(ConditionType.NONE);
            processTaskRelationLog.setConditionParams("{}");
            processTaskRelationLogs.add(processTaskRelationLog);
        }
        WorkflowTaskRelationLog processTaskRelationLogFirst = (WorkflowTaskRelationLog)processTaskRelationLogs.get(0);
        processTaskRelationLogFirst.setPreTaskCode(0L);
        processTaskRelationLogFirst.setPreTaskVersion(0);
        processTaskRelationLogFirst.setPostTaskCode(((Long)taskCodes.get(0)).longValue());
        processTaskRelationLogFirst.setPostTaskVersion(1);
        WorkflowTaskRelationLog processTaskRelationLogSecond = (WorkflowTaskRelationLog)processTaskRelationLogs.get(1);
        processTaskRelationLogSecond.setPreTaskCode(((Long)taskCodes.get(0)).longValue());
        processTaskRelationLogSecond.setPreTaskVersion(1);
        processTaskRelationLogSecond.setPostTaskCode(((Long)taskCodes.get(1)).longValue());
        processTaskRelationLogSecond.setPostTaskVersion(1);
        String taskRelationJson = JSONUtils.toJsonString(processTaskRelationLogs);
        ArrayList<TaskDefinitionLog> taskDefinitionLogs = new ArrayList<TaskDefinitionLog>();
        for (int i = 0; i < 2; ++i) {
            TaskDefinitionLog taskDefinitionLog = new TaskDefinitionLog();
            taskDefinitionLog.setFlag(Flag.YES);
            taskDefinitionLog.setDelayTime(0);
            taskDefinitionLog.setEnvironmentCode(-1L);
            taskDefinitionLog.setFailRetryInterval(1);
            taskDefinitionLog.setFailRetryTimes(0);
            taskDefinitionLog.setTaskPriority(Priority.MEDIUM);
            taskDefinitionLog.setTimeout(0);
            taskDefinitionLog.setTimeoutFlag(TimeoutFlag.CLOSE);
            taskDefinitionLog.setTimeoutNotifyStrategy(null);
            taskDefinitionLog.setWorkerGroup("default");
            taskDefinitionLogs.add(taskDefinitionLog);
        }
        TaskDefinitionLog taskDefinitionLogFirst = (TaskDefinitionLog)taskDefinitionLogs.get(0);
        taskDefinitionLogFirst.setCode(((Long)taskCodes.get(0)).longValue());
        taskDefinitionLogFirst.setName("Weekly report task");
        taskDefinitionLogFirst.setDescription("The weekly report task requires the demo_shell and demo_switch tasks to be successfully executed every day of the last week");
        taskDefinitionLogFirst.setTaskParams("{\"localParams\":[],\"resourceList\":[],\"dependence\":{\"relation\":\"AND\",\"dependTaskList\":[{\"relation\":\"AND\",\"dependItemList\":[{\"projectCode\":" + projectCode + ",\"definitionCode\":" + shellProcessCode + ",\"depTaskCode\":0,\"cycle\":\"day\",\"dateValue\":\"last1Days\",\"state\":null},{\"projectCode\":" + projectCode + ",\"definitionCode\":" + switchProcessCode + ",\"depTaskCode\":0,\"cycle\":\"day\",\"dateValue\":\"last1Days\",\"state\":null}]}]}}");
        taskDefinitionLogFirst.setTaskType("DEPENDENT");
        TaskDefinitionLog taskDefinitionLogSecond = (TaskDefinitionLog)taskDefinitionLogs.get(1);
        taskDefinitionLogSecond.setCode(((Long)taskCodes.get(1)).longValue());
        taskDefinitionLogSecond.setName("Weekly Report Task Result");
        taskDefinitionLogSecond.setDescription("Result report after the completion of the weekly report task");
        taskDefinitionLogSecond.setTaskParams("{\"localParams\":[],\"rawScript\":\"echo \\\"end of report\\\"\",\"resourceList\":[]}");
        taskDefinitionLogSecond.setTaskType("SHELL");
        String taskDefinitionJson = JSONUtils.toJsonString(taskDefinitionLogs);
        ProxyResult ProxyResult2 = this.proxyProcessDefinitionController.createProcessDefinition(token, projectCode, processDefinitionLog.getName(), processDefinitionLog.getDescription(), processDefinitionLog.getGlobalParams(), processDefinitionLog.getLocations(), processDefinitionLog.getTimeout(), tenantCode, taskRelationJson, taskDefinitionJson, WorkflowExecutionTypeEnum.PARALLEL);
        return ProxyResult2;
    }

    public ProxyResult parameterContextDemo(String token, long projectCode, String tenantCode) {
        ArrayList<Long> taskCodes = new ArrayList<Long>();
        try {
            for (int i = 0; i < 2; ++i) {
                taskCodes.add(CodeGenerateUtils.genCode());
            }
        }
        catch (CodeGenerateUtils.CodeGenerateException e) {
            log.error("task code get error, ", (Throwable)e);
        }
        String taskCodeFirst = String.valueOf(taskCodes.get(0)).replaceAll("\\[|\\]", "");
        String taskCodeSecond = String.valueOf(taskCodes.get(1)).replaceAll("\\[|\\]", "");
        WorkflowDefinitionLog processDefinitionLog = new WorkflowDefinitionLog();
        processDefinitionLog.setName("demo_parameter_context");
        processDefinitionLog.setDescription("Upstream and downstream task node parameter transfer");
        processDefinitionLog.setGlobalParams("[{\"prop\":\"output\",\"value\":\"100\",\"direct\":\"IN\",\"type\":\"VARCHAR\"},{\"prop\":\"value\",\"value\":\"99\",\"direct\":\"IN\",\"type\":\"VARCHAR\"}]");
        processDefinitionLog.setLocations(null);
        processDefinitionLog.setTimeout(0);
        ArrayList<WorkflowTaskRelationLog> processTaskRelationLogs = new ArrayList<WorkflowTaskRelationLog>();
        for (int i = 0; i < 2; ++i) {
            WorkflowTaskRelationLog processTaskRelationLog = new WorkflowTaskRelationLog();
            processTaskRelationLog.setName("");
            processTaskRelationLog.setConditionType(ConditionType.NONE);
            processTaskRelationLog.setConditionParams("{}");
            processTaskRelationLogs.add(processTaskRelationLog);
        }
        WorkflowTaskRelationLog processTaskRelationLogFirst = (WorkflowTaskRelationLog)processTaskRelationLogs.get(0);
        processTaskRelationLogFirst.setPreTaskCode(0L);
        processTaskRelationLogFirst.setPreTaskVersion(0);
        processTaskRelationLogFirst.setPostTaskCode(((Long)taskCodes.get(0)).longValue());
        processTaskRelationLogFirst.setPostTaskVersion(1);
        WorkflowTaskRelationLog processTaskRelationLogSecond = (WorkflowTaskRelationLog)processTaskRelationLogs.get(1);
        processTaskRelationLogSecond.setPreTaskCode(((Long)taskCodes.get(0)).longValue());
        processTaskRelationLogSecond.setPreTaskVersion(1);
        processTaskRelationLogSecond.setPostTaskCode(((Long)taskCodes.get(1)).longValue());
        processTaskRelationLogSecond.setPostTaskVersion(1);
        String taskRelationJson = JSONUtils.toJsonString(processTaskRelationLogs);
        ArrayList<TaskDefinitionLog> taskDefinitionLogs = new ArrayList<TaskDefinitionLog>();
        for (int i = 0; i < 2; ++i) {
            TaskDefinitionLog taskDefinitionLog = new TaskDefinitionLog();
            taskDefinitionLog.setFlag(Flag.YES);
            taskDefinitionLog.setDelayTime(0);
            taskDefinitionLog.setEnvironmentCode(-1L);
            taskDefinitionLog.setFailRetryInterval(1);
            taskDefinitionLog.setFailRetryTimes(0);
            taskDefinitionLog.setTaskPriority(Priority.MEDIUM);
            taskDefinitionLog.setTimeout(0);
            taskDefinitionLog.setTimeoutFlag(TimeoutFlag.CLOSE);
            taskDefinitionLog.setTimeoutNotifyStrategy(null);
            taskDefinitionLog.setWorkerGroup("default");
            taskDefinitionLog.setTaskType("SHELL");
            taskDefinitionLogs.add(taskDefinitionLog);
        }
        TaskDefinitionLog taskDefinitionLogFirst = (TaskDefinitionLog)taskDefinitionLogs.get(0);
        taskDefinitionLogFirst.setCode(((Long)taskCodes.get(0)).longValue());
        taskDefinitionLogFirst.setName("Upstream task node");
        taskDefinitionLogFirst.setDescription("Create a local parameter and pass the assignment to the downstream");
        taskDefinitionLogFirst.setTaskParams("{\"localParams\":[{\"prop\":\"value\",\"direct\":\"IN\",\"type\":\"VARCHAR\",\"value\":\"0\"},{\"prop\":\"output\",\"direct\":\"OUT\",\"type\":\"VARCHAR\",\"value\":\"\"}],\"rawScript\":\"echo \\\"====Node start====\\\"\\r\\necho '${setValue(output=1)}'\\r\\n\\r\\necho ${output}\\r\\necho ${value}\\r\\n\\r\\necho \\\"====Node end====\\\"\",\"resourceList\":[]}");
        TaskDefinitionLog taskDefinitionLogSecond = (TaskDefinitionLog)taskDefinitionLogs.get(1);
        taskDefinitionLogSecond.setCode(((Long)taskCodes.get(1)).longValue());
        taskDefinitionLogSecond.setName("Downstream task node");
        taskDefinitionLogSecond.setDescription("Test outputs the parameters passed by the upstream task");
        taskDefinitionLogSecond.setTaskParams("{\"localParams\":[],\"rawScript\":\"echo \\\"====node start====\\\"\\r\\n\\r\\necho ${output}\\r\\n\\r\\necho ${value}\\r\\n\\r\\necho \\\"====Node end====\\\"\",\"resourceList\":[]}");
        String taskDefinitionJson = JSONUtils.toJsonString(taskDefinitionLogs);
        ProxyResult ProxyResult2 = this.proxyProcessDefinitionController.createProcessDefinition(token, projectCode, processDefinitionLog.getName(), processDefinitionLog.getDescription(), processDefinitionLog.getGlobalParams(), processDefinitionLog.getLocations(), processDefinitionLog.getTimeout(), tenantCode, taskRelationJson, taskDefinitionJson, WorkflowExecutionTypeEnum.PARALLEL);
        return ProxyResult2;
    }

    public ProxyResult conditionDemo(String token, long projectCode, String tenantCode) {
        ArrayList<Long> taskCodes = new ArrayList<Long>();
        try {
            for (int i = 0; i < 4; ++i) {
                taskCodes.add(CodeGenerateUtils.genCode());
            }
        }
        catch (CodeGenerateUtils.CodeGenerateException e) {
            log.error("task code get error, ", (Throwable)e);
        }
        String taskCodeFirst = String.valueOf(taskCodes.get(0)).replaceAll("\\[|\\]", "");
        String taskCodeSecond = String.valueOf(taskCodes.get(1)).replaceAll("\\[|\\]", "");
        String taskCodeThird = String.valueOf(taskCodes.get(2)).replaceAll("\\[|\\]", "");
        String taskCodeFourth = String.valueOf(taskCodes.get(3)).replaceAll("\\[|\\]", "");
        WorkflowDefinitionLog processDefinitionLog = new WorkflowDefinitionLog();
        processDefinitionLog.setName("demo_condition");
        processDefinitionLog.setDescription("Coin Toss");
        processDefinitionLog.setGlobalParams("[]");
        processDefinitionLog.setLocations(null);
        processDefinitionLog.setTimeout(0);
        ArrayList<WorkflowTaskRelationLog> processTaskRelationLogs = new ArrayList<WorkflowTaskRelationLog>();
        for (int i = 0; i < 4; ++i) {
            WorkflowTaskRelationLog processTaskRelationLog = new WorkflowTaskRelationLog();
            processTaskRelationLog.setName("");
            processTaskRelationLog.setConditionType(ConditionType.NONE);
            processTaskRelationLog.setConditionParams("{}");
            processTaskRelationLogs.add(processTaskRelationLog);
        }
        WorkflowTaskRelationLog processTaskRelationLogFirst = (WorkflowTaskRelationLog)processTaskRelationLogs.get(0);
        processTaskRelationLogFirst.setPreTaskCode(0L);
        processTaskRelationLogFirst.setPreTaskVersion(0);
        processTaskRelationLogFirst.setPostTaskCode(((Long)taskCodes.get(1)).longValue());
        processTaskRelationLogFirst.setPostTaskVersion(1);
        WorkflowTaskRelationLog processTaskRelationLogSecond = (WorkflowTaskRelationLog)processTaskRelationLogs.get(1);
        processTaskRelationLogSecond.setPreTaskCode(((Long)taskCodes.get(0)).longValue());
        processTaskRelationLogSecond.setPreTaskVersion(1);
        processTaskRelationLogSecond.setPostTaskCode(((Long)taskCodes.get(2)).longValue());
        processTaskRelationLogSecond.setPostTaskVersion(1);
        WorkflowTaskRelationLog processTaskRelationLogThird = (WorkflowTaskRelationLog)processTaskRelationLogs.get(2);
        processTaskRelationLogThird.setPreTaskCode(((Long)taskCodes.get(0)).longValue());
        processTaskRelationLogThird.setPreTaskVersion(1);
        processTaskRelationLogThird.setPostTaskCode(((Long)taskCodes.get(3)).longValue());
        processTaskRelationLogThird.setPostTaskVersion(1);
        WorkflowTaskRelationLog processTaskRelationLogFourth = (WorkflowTaskRelationLog)processTaskRelationLogs.get(3);
        processTaskRelationLogFourth.setPreTaskCode(((Long)taskCodes.get(1)).longValue());
        processTaskRelationLogFourth.setPreTaskVersion(1);
        processTaskRelationLogFourth.setPostTaskCode(((Long)taskCodes.get(0)).longValue());
        processTaskRelationLogFourth.setPostTaskVersion(1);
        String taskRelationJson = JSONUtils.toJsonString(processTaskRelationLogs);
        ArrayList<TaskDefinitionLog> taskDefinitionLogs = new ArrayList<TaskDefinitionLog>();
        for (int i = 0; i < 4; ++i) {
            TaskDefinitionLog taskDefinitionLog = new TaskDefinitionLog();
            taskDefinitionLog.setFlag(Flag.YES);
            taskDefinitionLog.setDelayTime(0);
            taskDefinitionLog.setEnvironmentCode(-1L);
            taskDefinitionLog.setFailRetryInterval(1);
            taskDefinitionLog.setFailRetryTimes(0);
            taskDefinitionLog.setTaskPriority(Priority.MEDIUM);
            taskDefinitionLog.setTimeout(0);
            taskDefinitionLog.setTimeoutFlag(TimeoutFlag.CLOSE);
            taskDefinitionLog.setTimeoutNotifyStrategy(null);
            taskDefinitionLog.setWorkerGroup("default");
            taskDefinitionLogs.add(taskDefinitionLog);
        }
        TaskDefinitionLog taskDefinitionLogFirst = (TaskDefinitionLog)taskDefinitionLogs.get(0);
        taskDefinitionLogFirst.setCode(((Long)taskCodes.get(0)).longValue());
        taskDefinitionLogFirst.setName("condition");
        taskDefinitionLogFirst.setDescription("head is the status of success, tail is the status of failure");
        taskDefinitionLogFirst.setTaskParams("{\"localParams\":[],\"resourceList\":[],\"dependence\":{\"relation\":\"AND\",\"dependTaskList\":[]},\"conditionResult\":{\"successNode\":[" + taskCodeThird + "],\"failedNode\":[" + taskCodeFourth + "]}}");
        taskDefinitionLogFirst.setTaskType("CONDITIONS");
        TaskDefinitionLog taskDefinitionLogSecond = (TaskDefinitionLog)taskDefinitionLogs.get(1);
        taskDefinitionLogSecond.setCode(((Long)taskCodes.get(1)).longValue());
        taskDefinitionLogSecond.setName("coin");
        taskDefinitionLogSecond.setDescription("Toss a coin");
        taskDefinitionLogSecond.setTaskParams("{\"localParams\":[],\"rawScript\":\"echo \\\"Start\\\"\",\"resourceList\":[]}");
        taskDefinitionLogSecond.setTaskType("SHELL");
        TaskDefinitionLog taskDefinitionLogThird = (TaskDefinitionLog)taskDefinitionLogs.get(2);
        taskDefinitionLogThird.setCode(((Long)taskCodes.get(2)).longValue());
        taskDefinitionLogThird.setName("head");
        taskDefinitionLogThird.setDescription("Choose to learn if the result is head");
        taskDefinitionLogThird.setTaskParams("{\"localParams\":[],\"rawScript\":\"echo \\\"Start learning\\\"\",\"resourceList\":[]}");
        taskDefinitionLogThird.setTaskType("SHELL");
        TaskDefinitionLog taskDefinitionLogFourth = (TaskDefinitionLog)taskDefinitionLogs.get(3);
        taskDefinitionLogFourth.setCode(((Long)taskCodes.get(3)).longValue());
        taskDefinitionLogFourth.setName("tail");
        taskDefinitionLogFourth.setDescription("Choose to play if the result is tail");
        taskDefinitionLogFourth.setTaskParams("{\"localParams\":[],\"rawScript\":\"echo \\\"Start playing\\\"\",\"resourceList\":[]}");
        taskDefinitionLogFourth.setTaskType("SHELL");
        String taskDefinitionJson = JSONUtils.toJsonString(taskDefinitionLogs);
        ProxyResult ProxyResult2 = this.proxyProcessDefinitionController.createProcessDefinition(token, projectCode, processDefinitionLog.getName(), processDefinitionLog.getDescription(), processDefinitionLog.getGlobalParams(), processDefinitionLog.getLocations(), processDefinitionLog.getTimeout(), tenantCode, taskRelationJson, taskDefinitionJson, WorkflowExecutionTypeEnum.PARALLEL);
        return ProxyResult2;
    }

    public ProxyResult swicthDemo(String token, long projectCode, String tenantCode) {
        ArrayList<Long> taskCodes = new ArrayList<Long>();
        try {
            for (int i = 0; i < 4; ++i) {
                taskCodes.add(CodeGenerateUtils.genCode());
            }
        }
        catch (CodeGenerateUtils.CodeGenerateException e) {
            log.error("task code get error, ", (Throwable)e);
        }
        String taskCodeFirst = String.valueOf(taskCodes.get(0)).replaceAll("\\[|\\]", "");
        String taskCodeSecond = String.valueOf(taskCodes.get(1)).replaceAll("\\[|\\]", "");
        String taskCodeThird = String.valueOf(taskCodes.get(2)).replaceAll("\\[|\\]", "");
        String taskCodeFourth = String.valueOf(taskCodes.get(3)).replaceAll("\\[|\\]", "");
        WorkflowDefinitionLog processDefinitionLog = new WorkflowDefinitionLog();
        processDefinitionLog.setName("demo_switch");
        processDefinitionLog.setDescription("Determine which task to perform based on conditions");
        processDefinitionLog.setGlobalParams("[{\"prop\":\"switchValue\",\"value\":\"A\",\"direct\":\"IN\",\"type\":\"VARCHAR\"}]");
        processDefinitionLog.setLocations(null);
        processDefinitionLog.setTimeout(0);
        ArrayList<WorkflowTaskRelationLog> processTaskRelationLogs = new ArrayList<WorkflowTaskRelationLog>();
        for (int i = 0; i < 4; ++i) {
            WorkflowTaskRelationLog processTaskRelationLog = new WorkflowTaskRelationLog();
            processTaskRelationLog.setName("");
            processTaskRelationLog.setConditionType(ConditionType.NONE);
            processTaskRelationLog.setConditionParams("{}");
            processTaskRelationLogs.add(processTaskRelationLog);
        }
        WorkflowTaskRelationLog processTaskRelationLogFirst = (WorkflowTaskRelationLog)processTaskRelationLogs.get(0);
        processTaskRelationLogFirst.setPreTaskCode(0L);
        processTaskRelationLogFirst.setPreTaskVersion(0);
        processTaskRelationLogFirst.setPostTaskCode(((Long)taskCodes.get(0)).longValue());
        processTaskRelationLogFirst.setPostTaskVersion(1);
        WorkflowTaskRelationLog processTaskRelationLogSecond = (WorkflowTaskRelationLog)processTaskRelationLogs.get(1);
        processTaskRelationLogSecond.setPreTaskCode(((Long)taskCodes.get(0)).longValue());
        processTaskRelationLogSecond.setPreTaskVersion(1);
        processTaskRelationLogSecond.setPostTaskCode(((Long)taskCodes.get(1)).longValue());
        processTaskRelationLogSecond.setPostTaskVersion(1);
        WorkflowTaskRelationLog processTaskRelationLogThird = (WorkflowTaskRelationLog)processTaskRelationLogs.get(2);
        processTaskRelationLogThird.setPreTaskCode(((Long)taskCodes.get(0)).longValue());
        processTaskRelationLogThird.setPreTaskVersion(1);
        processTaskRelationLogThird.setPostTaskCode(((Long)taskCodes.get(2)).longValue());
        processTaskRelationLogThird.setPostTaskVersion(1);
        WorkflowTaskRelationLog processTaskRelationLogFourth = (WorkflowTaskRelationLog)processTaskRelationLogs.get(3);
        processTaskRelationLogFourth.setPreTaskCode(((Long)taskCodes.get(0)).longValue());
        processTaskRelationLogFourth.setPreTaskVersion(1);
        processTaskRelationLogFourth.setPostTaskCode(((Long)taskCodes.get(3)).longValue());
        processTaskRelationLogFourth.setPostTaskVersion(1);
        String taskRelationJson = JSONUtils.toJsonString(processTaskRelationLogs);
        ArrayList<TaskDefinitionLog> taskDefinitionLogs = new ArrayList<TaskDefinitionLog>();
        for (int i = 0; i < 4; ++i) {
            TaskDefinitionLog taskDefinitionLog = new TaskDefinitionLog();
            taskDefinitionLog.setFlag(Flag.YES);
            taskDefinitionLog.setDelayTime(0);
            taskDefinitionLog.setEnvironmentCode(-1L);
            taskDefinitionLog.setFailRetryInterval(1);
            taskDefinitionLog.setFailRetryTimes(0);
            taskDefinitionLog.setTaskPriority(Priority.MEDIUM);
            taskDefinitionLog.setTimeout(0);
            taskDefinitionLog.setTimeoutFlag(TimeoutFlag.CLOSE);
            taskDefinitionLog.setTimeoutNotifyStrategy(null);
            taskDefinitionLog.setWorkerGroup("default");
            taskDefinitionLogs.add(taskDefinitionLog);
        }
        TaskDefinitionLog taskDefinitionLogFirst = (TaskDefinitionLog)taskDefinitionLogs.get(0);
        taskDefinitionLogFirst.setCode(((Long)taskCodes.get(0)).longValue());
        taskDefinitionLogFirst.setName("switch node");
        taskDefinitionLogFirst.setDescription("The global parameter is to execute TaskA for A, and for B to execute TaskB, otherwise the default task is executed");
        taskDefinitionLogFirst.setTaskParams("{\"localParams\":[],\"rawScript\":\"\",\"resourceList\":[],\"switchResult\":{\"dependTaskList\":[{\"condition\":\"${switchValue} == \\\"A\\\"\",\"nextNode\":" + taskCodeThird + "},{\"condition\":\"${switchValue} == \\\"B\\\"\",\"nextNode\":" + taskCodeFourth + "}],\"nextNode\":" + taskCodeSecond + "}}");
        taskDefinitionLogFirst.setTaskType("SWITCH");
        TaskDefinitionLog taskDefinitionLogSecond = (TaskDefinitionLog)taskDefinitionLogs.get(1);
        taskDefinitionLogSecond.setCode(((Long)taskCodes.get(1)).longValue());
        taskDefinitionLogSecond.setName("default");
        taskDefinitionLogSecond.setDescription("executed default task");
        taskDefinitionLogSecond.setTaskParams("{\"localParams\":[],\"rawScript\":\"echo \\\"default\\\"\",\"resourceList\":[]}");
        taskDefinitionLogSecond.setTaskType("SHELL");
        TaskDefinitionLog taskDefinitionLogThird = (TaskDefinitionLog)taskDefinitionLogs.get(2);
        taskDefinitionLogThird.setCode(((Long)taskCodes.get(2)).longValue());
        taskDefinitionLogThird.setName("TaskA");
        taskDefinitionLogThird.setDescription("execute TaskA");
        taskDefinitionLogThird.setTaskParams("{\"localParams\":[],\"rawScript\":\"echo \\\"TaskA\\\"\",\"resourceList\":[]}");
        taskDefinitionLogThird.setTaskType("SHELL");
        TaskDefinitionLog taskDefinitionLogFourth = (TaskDefinitionLog)taskDefinitionLogs.get(3);
        taskDefinitionLogFourth.setCode(((Long)taskCodes.get(3)).longValue());
        taskDefinitionLogFourth.setName("TaskB");
        taskDefinitionLogFourth.setDescription("execute TaskB");
        taskDefinitionLogFourth.setTaskParams("{\"localParams\":[],\"rawScript\":\"echo \\\"TaskB\\\"\",\"resourceList\":[]}");
        taskDefinitionLogFourth.setTaskType("SHELL");
        String taskDefinitionJson = JSONUtils.toJsonString(taskDefinitionLogs);
        ProxyResult ProxyResult2 = this.proxyProcessDefinitionController.createProcessDefinition(token, projectCode, processDefinitionLog.getName(), processDefinitionLog.getDescription(), processDefinitionLog.getGlobalParams(), processDefinitionLog.getLocations(), processDefinitionLog.getTimeout(), tenantCode, taskRelationJson, taskDefinitionJson, WorkflowExecutionTypeEnum.PARALLEL);
        return ProxyResult2;
    }

    public ProxyResult shellDemo(String token, long projectCode, String tenantCode) {
        ArrayList<Long> taskCodes = new ArrayList<Long>();
        try {
            for (int i = 0; i < 3; ++i) {
                taskCodes.add(CodeGenerateUtils.genCode());
            }
        }
        catch (CodeGenerateUtils.CodeGenerateException e) {
            log.error("task code get error, ", (Throwable)e);
        }
        String taskCodeFirst = String.valueOf(taskCodes.get(0)).replaceAll("\\[|\\]", "");
        String taskCodeSecond = String.valueOf(taskCodes.get(1)).replaceAll("\\[|\\]", "");
        String taskCodeThird = String.valueOf(taskCodes.get(2)).replaceAll("\\[|\\]", "");
        WorkflowDefinitionLog processDefinitionLog = new WorkflowDefinitionLog();
        processDefinitionLog.setName("demo_shell");
        processDefinitionLog.setDescription("Production, processing and sales of a series of processes");
        processDefinitionLog.setGlobalParams("[{\"prop\":\"resources\",\"value\":\"Processing information\",\"direct\":\"IN\",\"type\":\"VARCHAR\"}]");
        processDefinitionLog.setLocations(null);
        processDefinitionLog.setTimeout(0);
        ArrayList<WorkflowTaskRelationLog> processTaskRelationLogs = new ArrayList<WorkflowTaskRelationLog>();
        for (int i = 0; i < 3; ++i) {
            WorkflowTaskRelationLog processTaskRelationLog = new WorkflowTaskRelationLog();
            processTaskRelationLog.setName("");
            processTaskRelationLog.setConditionType(ConditionType.NONE);
            processTaskRelationLog.setConditionParams("{}");
            processTaskRelationLogs.add(processTaskRelationLog);
        }
        WorkflowTaskRelationLog processTaskRelationLogFirst = (WorkflowTaskRelationLog)processTaskRelationLogs.get(0);
        processTaskRelationLogFirst.setPreTaskCode(0L);
        processTaskRelationLogFirst.setPreTaskVersion(0);
        processTaskRelationLogFirst.setPostTaskCode(((Long)taskCodes.get(0)).longValue());
        processTaskRelationLogFirst.setPostTaskVersion(1);
        WorkflowTaskRelationLog processTaskRelationLogSecond = (WorkflowTaskRelationLog)processTaskRelationLogs.get(1);
        processTaskRelationLogSecond.setPreTaskCode(((Long)taskCodes.get(0)).longValue());
        processTaskRelationLogSecond.setPreTaskVersion(1);
        processTaskRelationLogSecond.setPostTaskCode(((Long)taskCodes.get(1)).longValue());
        processTaskRelationLogSecond.setPostTaskVersion(1);
        WorkflowTaskRelationLog processTaskRelationLogThird = (WorkflowTaskRelationLog)processTaskRelationLogs.get(2);
        processTaskRelationLogThird.setPreTaskCode(((Long)taskCodes.get(1)).longValue());
        processTaskRelationLogThird.setPreTaskVersion(1);
        processTaskRelationLogThird.setPostTaskCode(((Long)taskCodes.get(2)).longValue());
        processTaskRelationLogThird.setPostTaskVersion(1);
        String taskRelationJson = JSONUtils.toJsonString(processTaskRelationLogs);
        ArrayList<TaskDefinitionLog> taskDefinitionLogs = new ArrayList<TaskDefinitionLog>();
        for (int i = 0; i < 3; ++i) {
            TaskDefinitionLog taskDefinitionLog = new TaskDefinitionLog();
            taskDefinitionLog.setFlag(Flag.YES);
            taskDefinitionLog.setDelayTime(0);
            taskDefinitionLog.setEnvironmentCode(-1L);
            taskDefinitionLog.setFailRetryInterval(1);
            taskDefinitionLog.setFailRetryTimes(0);
            taskDefinitionLog.setTaskPriority(Priority.MEDIUM);
            taskDefinitionLog.setTimeout(0);
            taskDefinitionLog.setTimeoutFlag(TimeoutFlag.CLOSE);
            taskDefinitionLog.setTimeoutNotifyStrategy(null);
            taskDefinitionLog.setWorkerGroup("default");
            taskDefinitionLog.setTaskType("SHELL");
            taskDefinitionLogs.add(taskDefinitionLog);
        }
        TaskDefinitionLog taskDefinitionLogFirst = (TaskDefinitionLog)taskDefinitionLogs.get(0);
        taskDefinitionLogFirst.setCode(((Long)taskCodes.get(0)).longValue());
        taskDefinitionLogFirst.setName("001");
        taskDefinitionLogFirst.setDescription("Make production order");
        taskDefinitionLogFirst.setTaskParams("{\"localParams\":[],\"rawScript\":\"echo \\\"start\\\"\",\"resourceList\":[]}");
        TaskDefinitionLog taskDefinitionLogSecond = (TaskDefinitionLog)taskDefinitionLogs.get(1);
        taskDefinitionLogSecond.setCode(((Long)taskCodes.get(1)).longValue());
        taskDefinitionLogSecond.setName("002");
        taskDefinitionLogSecond.setDescription("Get Information Processing");
        taskDefinitionLogSecond.setTaskParams("{\"localParams\":[],\"rawScript\":\"echo ${resources}\",\"resourceList\":[]}");
        TaskDefinitionLog taskDefinitionLogThird = (TaskDefinitionLog)taskDefinitionLogs.get(2);
        taskDefinitionLogThird.setCode(((Long)taskCodes.get(2)).longValue());
        taskDefinitionLogThird.setName("003");
        taskDefinitionLogThird.setDescription("Sell after completion");
        taskDefinitionLogThird.setTaskParams("{\"localParams\":[],\"rawScript\":\"echo \\\"end\\\"\",\"resourceList\":[]}");
        String taskDefinitionJson = JSONUtils.toJsonString(taskDefinitionLogs);
        ProxyResult ProxyResult2 = this.proxyProcessDefinitionController.createProcessDefinition(token, projectCode, processDefinitionLog.getName(), processDefinitionLog.getDescription(), processDefinitionLog.getGlobalParams(), processDefinitionLog.getLocations(), processDefinitionLog.getTimeout(), tenantCode, taskRelationJson, taskDefinitionJson, WorkflowExecutionTypeEnum.PARALLEL);
        return ProxyResult2;
    }

    public ProxyResult subProcessDemo(String token, long projectCode, String tenantCode, String subProcessCode) {
        ArrayList<Long> taskCodes = new ArrayList<Long>();
        try {
            for (int i = 0; i < 1; ++i) {
                taskCodes.add(CodeGenerateUtils.genCode());
            }
        }
        catch (CodeGenerateUtils.CodeGenerateException e) {
            log.error("task code get error, ", (Throwable)e);
        }
        String taskCode = String.valueOf(taskCodes.get(0)).replaceAll("\\[|\\]", "");
        WorkflowDefinitionLog processDefinitionLog = new WorkflowDefinitionLog();
        processDefinitionLog.setName("demo_sub_workflow");
        processDefinitionLog.setDescription("Start the production line");
        processDefinitionLog.setGlobalParams("[]");
        processDefinitionLog.setLocations(null);
        processDefinitionLog.setTimeout(0);
        ArrayList<WorkflowTaskRelationLog> processTaskRelationLogs = new ArrayList<WorkflowTaskRelationLog>();
        for (int i = 0; i < 1; ++i) {
            WorkflowTaskRelationLog processTaskRelationLog = new WorkflowTaskRelationLog();
            processTaskRelationLog.setName("");
            processTaskRelationLog.setConditionType(ConditionType.NONE);
            processTaskRelationLog.setConditionParams("{}");
            processTaskRelationLogs.add(processTaskRelationLog);
        }
        WorkflowTaskRelationLog processTaskRelationLogFirst = (WorkflowTaskRelationLog)processTaskRelationLogs.get(0);
        processTaskRelationLogFirst.setPreTaskCode(0L);
        processTaskRelationLogFirst.setPreTaskVersion(0);
        processTaskRelationLogFirst.setPostTaskCode(((Long)taskCodes.get(0)).longValue());
        processTaskRelationLogFirst.setPostTaskVersion(1);
        String taskRelationJson = JSONUtils.toJsonString(processTaskRelationLogs);
        ArrayList<TaskDefinitionLog> taskDefinitionLogs = new ArrayList<TaskDefinitionLog>();
        for (int i = 0; i < 1; ++i) {
            TaskDefinitionLog taskDefinitionLog = new TaskDefinitionLog();
            taskDefinitionLog.setFlag(Flag.YES);
            taskDefinitionLog.setDelayTime(0);
            taskDefinitionLog.setEnvironmentCode(-1L);
            taskDefinitionLog.setFailRetryInterval(1);
            taskDefinitionLog.setFailRetryTimes(0);
            taskDefinitionLog.setTaskPriority(Priority.MEDIUM);
            taskDefinitionLog.setTimeout(0);
            taskDefinitionLog.setTimeoutFlag(TimeoutFlag.CLOSE);
            taskDefinitionLog.setTimeoutNotifyStrategy(null);
            taskDefinitionLog.setWorkerGroup("default");
            taskDefinitionLog.setTaskType("SUB_WORKFLOW");
            taskDefinitionLogs.add(taskDefinitionLog);
        }
        TaskDefinitionLog taskDefinitionLogFirst = (TaskDefinitionLog)taskDefinitionLogs.get(0);
        taskDefinitionLogFirst.setCode(((Long)taskCodes.get(0)).longValue());
        taskDefinitionLogFirst.setName("subprocess node");
        taskDefinitionLogFirst.setDescription("Enter the demo_shell subnode");
        taskDefinitionLogFirst.setTaskParams("{\"localParams\":[],\"resourceList\":[],\"processDefinitionCode\":" + subProcessCode + "}");
        String taskDefinitionJson = JSONUtils.toJsonString(taskDefinitionLogs);
        ProxyResult ProxyResult2 = this.proxyProcessDefinitionController.createProcessDefinition(token, projectCode, processDefinitionLog.getName(), processDefinitionLog.getDescription(), processDefinitionLog.getGlobalParams(), processDefinitionLog.getLocations(), processDefinitionLog.getTimeout(), tenantCode, taskRelationJson, taskDefinitionJson, WorkflowExecutionTypeEnum.PARALLEL);
        return ProxyResult2;
    }
}

