/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.sqoop.generator.sources;

import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.DataSourceUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.sqoop.SqoopColumnType;
import org.apache.dolphinscheduler.plugin.task.sqoop.SqoopQueryType;
import org.apache.dolphinscheduler.plugin.task.sqoop.SqoopTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.ISourceGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.SqoopParameters;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.sources.SourceMysqlParameter;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLSourceGenerator
implements ISourceGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MySQLSourceGenerator.class);

    @Override
    public String generate(SqoopParameters sqoopParameters, SqoopTaskExecutionContext sqoopTaskExecutionContext) {
        StringBuilder mysqlSourceSb = new StringBuilder();
        try {
            SourceMysqlParameter sourceMysqlParameter = (SourceMysqlParameter)JSONUtils.parseObject((String)sqoopParameters.getSourceParams(), SourceMysqlParameter.class);
            if (null == sourceMysqlParameter) {
                return mysqlSourceSb.toString();
            }
            BaseConnectionParam baseDataSource = (BaseConnectionParam)DataSourceUtils.buildConnectionParams((DbType)sqoopTaskExecutionContext.getSourcetype(), (String)sqoopTaskExecutionContext.getSourceConnectionParams());
            if (null == baseDataSource) {
                return mysqlSourceSb.toString();
            }
            mysqlSourceSb.append(" ").append("--connect").append(" ").append("\"").append(DataSourceUtils.getJdbcUrl((DbType)DbType.MYSQL, (ConnectionParam)baseDataSource)).append("\"").append(" ").append("--username").append(" ").append(baseDataSource.getUser()).append(" ").append("--password").append(" ").append("\"").append(PasswordUtils.decodePassword((String)baseDataSource.getPassword())).append("\"");
            if (sourceMysqlParameter.getSrcQueryType() == SqoopQueryType.FORM.getCode().intValue()) {
                if (StringUtils.isNotEmpty((CharSequence)sourceMysqlParameter.getSrcTable())) {
                    mysqlSourceSb.append(" ").append("--table").append(" ").append(sourceMysqlParameter.getSrcTable());
                }
                if (sourceMysqlParameter.getSrcColumnType() == SqoopColumnType.CUSTOMIZE_COLUMNS.getCode().intValue() && StringUtils.isNotEmpty((CharSequence)sourceMysqlParameter.getSrcColumns())) {
                    mysqlSourceSb.append(" ").append("--columns").append(" ").append(sourceMysqlParameter.getSrcColumns());
                }
            } else if (sourceMysqlParameter.getSrcQueryType() == SqoopQueryType.SQL.getCode().intValue() && StringUtils.isNotEmpty((CharSequence)sourceMysqlParameter.getSrcQuerySql())) {
                String srcQuery = sourceMysqlParameter.getSrcQuerySql();
                mysqlSourceSb.append(" ").append("--query").append(" ").append("\"").append(srcQuery);
                if (srcQuery.toLowerCase().contains("where")) {
                    mysqlSourceSb.append(" ").append("AND \\$CONDITIONS").append("\"");
                } else {
                    mysqlSourceSb.append(" ").append("WHERE \\$CONDITIONS").append("\"");
                }
            }
            MySQLSourceGenerator.buildColumnMapToHIve(mysqlSourceSb, sourceMysqlParameter);
            MySQLSourceGenerator.buildColumnMapToJava(mysqlSourceSb, sourceMysqlParameter);
        }
        catch (Exception e) {
            log.error(String.format("Sqoop task mysql source params build failed: [%s]", e.getMessage()));
        }
        return mysqlSourceSb.toString();
    }

    private static void buildColumnMapToHIve(StringBuilder mysqlSourceSb, SourceMysqlParameter sourceMysqlParameter) {
        List<Property> mapColumnHive = sourceMysqlParameter.getMapColumnHive();
        if (null != mapColumnHive && !mapColumnHive.isEmpty()) {
            StringBuilder columnMap = new StringBuilder();
            for (Property item : mapColumnHive) {
                columnMap.append(item.getProp()).append("=").append(item.getValue()).append(",");
            }
            if (StringUtils.isNotEmpty((CharSequence)columnMap.toString())) {
                mysqlSourceSb.append(" ").append("--map-column-hive").append(" ").append(columnMap.substring(0, columnMap.length() - 1));
            }
        }
    }

    private static void buildColumnMapToJava(StringBuilder mysqlSourceSb, SourceMysqlParameter sourceMysqlParameter) {
        List<Property> mapColumnJava = sourceMysqlParameter.getMapColumnJava();
        if (null != mapColumnJava && !mapColumnJava.isEmpty()) {
            StringBuilder columnMap = new StringBuilder();
            for (Property item : mapColumnJava) {
                columnMap.append(item.getProp()).append("=").append(item.getValue()).append(",");
            }
            if (StringUtils.isNotEmpty((CharSequence)columnMap.toString())) {
                mysqlSourceSb.append(" ").append("--map-column-java").append(" ").append(columnMap.substring(0, columnMap.length() - 1));
            }
        }
    }
}

