/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.sqoop.generator.targets;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.DataSourceUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.task.sqoop.SqoopTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.ITargetGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.SqoopParameters;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.targets.TargetMysqlParameter;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLTargetGenerator
implements ITargetGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MySQLTargetGenerator.class);

    @Override
    public String generate(SqoopParameters sqoopParameters, SqoopTaskExecutionContext sqoopTaskExecutionContext) {
        StringBuilder mysqlTargetSb = new StringBuilder();
        try {
            BaseConnectionParam baseDataSource;
            TargetMysqlParameter targetMysqlParameter = (TargetMysqlParameter)JSONUtils.parseObject((String)sqoopParameters.getTargetParams(), TargetMysqlParameter.class);
            if (null != targetMysqlParameter && targetMysqlParameter.getTargetDatasource() != 0 && null != (baseDataSource = (BaseConnectionParam)DataSourceUtils.buildConnectionParams((DbType)sqoopTaskExecutionContext.getTargetType(), (String)sqoopTaskExecutionContext.getTargetConnectionParams()))) {
                mysqlTargetSb.append(" ").append("--connect").append(" ").append("\"").append(DataSourceUtils.getJdbcUrl((DbType)DbType.MYSQL, (ConnectionParam)baseDataSource)).append("\"").append(" ").append("--username").append(" ").append(baseDataSource.getUser()).append(" ").append("--password").append(" ").append("\"").append(PasswordUtils.decodePassword((String)baseDataSource.getPassword())).append("\"").append(" ").append("--table").append(" ").append(targetMysqlParameter.getTargetTable());
                if (StringUtils.isNotEmpty((CharSequence)targetMysqlParameter.getTargetColumns())) {
                    mysqlTargetSb.append(" ").append("--columns").append(" ").append(targetMysqlParameter.getTargetColumns());
                }
                if (StringUtils.isNotEmpty((CharSequence)targetMysqlParameter.getFieldsTerminated())) {
                    mysqlTargetSb.append(" ").append("--fields-terminated-by");
                    if (targetMysqlParameter.getFieldsTerminated().contains("'")) {
                        mysqlTargetSb.append(" ").append(targetMysqlParameter.getFieldsTerminated());
                    } else {
                        mysqlTargetSb.append(" ").append("'").append(targetMysqlParameter.getFieldsTerminated()).append("'");
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)targetMysqlParameter.getLinesTerminated())) {
                    mysqlTargetSb.append(" ").append("--lines-terminated-by");
                    if (targetMysqlParameter.getLinesTerminated().contains("'")) {
                        mysqlTargetSb.append(" ").append(targetMysqlParameter.getLinesTerminated());
                    } else {
                        mysqlTargetSb.append(" ").append("'").append(targetMysqlParameter.getLinesTerminated()).append("'");
                    }
                }
                if (targetMysqlParameter.getIsUpdate() && StringUtils.isNotEmpty((CharSequence)targetMysqlParameter.getTargetUpdateKey()) && StringUtils.isNotEmpty((CharSequence)targetMysqlParameter.getTargetUpdateMode())) {
                    mysqlTargetSb.append(" ").append("--update-key").append(" ").append(targetMysqlParameter.getTargetUpdateKey()).append(" ").append("--update-mode").append(" ").append(targetMysqlParameter.getTargetUpdateMode());
                }
            }
        }
        catch (Exception e) {
            log.error(String.format("Sqoop mysql target params build failed: [%s]", e.getMessage()));
        }
        return mysqlTargetSb.toString();
    }
}

