/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.shell;

import java.util.Map;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractTask;
import org.apache.dolphinscheduler.plugin.task.api.ShellCommandExecutor;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.TaskResponse;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.shell.IShellInterceptorBuilder;
import org.apache.dolphinscheduler.plugin.task.api.shell.ShellInterceptorBuilderFactory;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.shell.ShellParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellTask
extends AbstractTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShellTask.class);
    private ShellParameters shellParameters;
    private ShellCommandExecutor shellCommandExecutor;
    private TaskExecutionContext taskExecutionContext;

    public ShellTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
        this.shellCommandExecutor = new ShellCommandExecutor(arg_0 -> ((ShellTask)this).logHandle(arg_0), taskExecutionContext);
    }

    public void init() {
        this.shellParameters = (ShellParameters)((Object)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), ShellParameters.class));
        log.info("Initialize shell task params {}", (Object)JSONUtils.toPrettyJsonString((Object)((Object)this.shellParameters)));
        if (this.shellParameters == null || !this.shellParameters.checkParameters()) {
            throw new TaskException("shell task params is not valid");
        }
    }

    public void handle(TaskCallBack taskCallBack) throws TaskException {
        try {
            IShellInterceptorBuilder shellActuatorBuilder = ShellInterceptorBuilderFactory.newBuilder().properties(ParameterUtils.convert((Map)this.taskExecutionContext.getPrepareParamsMap())).appendScript(this.shellParameters.getRawScript());
            TaskResponse commandExecuteResult = this.shellCommandExecutor.run(shellActuatorBuilder, taskCallBack);
            this.setExitStatusCode(commandExecuteResult.getExitStatusCode());
            this.setProcessId(commandExecuteResult.getProcessId());
            this.shellParameters.dealOutParam(this.shellCommandExecutor.getTaskOutputParams());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("The current Shell task has been interrupted", (Throwable)e);
            this.setExitStatusCode(-1);
            throw new TaskException("The current Shell task has been interrupted", (Throwable)e);
        }
        catch (Exception e) {
            log.error("shell task error", (Throwable)e);
            this.setExitStatusCode(-1);
            throw new TaskException("Execute shell task error", (Throwable)e);
        }
    }

    public void cancel() throws TaskException {
        try {
            this.shellCommandExecutor.cancelApplication();
        }
        catch (Exception e) {
            throw new TaskException("cancel application error", (Throwable)e);
        }
    }

    public AbstractParameters getParameters() {
        return this.shellParameters;
    }
}

