/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.openmldb;

import com.google.common.base.Preconditions;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.openmldb.OpenmldbParameters;
import org.apache.dolphinscheduler.plugin.task.python.PythonParameters;
import org.apache.dolphinscheduler.plugin.task.python.PythonTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenmldbTask
extends PythonTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenmldbTask.class);
    private static final String OPENMLDB_PYTHON = "python3";
    private static final Pattern PYTHON_PATH_PATTERN = Pattern.compile("/bin/python[\\d.]*$");
    public static final Pattern SQL_PATTERN = Pattern.compile("\\S");

    public OpenmldbTask(TaskExecutionContext taskRequest) {
        super(taskRequest);
    }

    public void init() {
        this.pythonParameters = (PythonParameters)JSONUtils.parseObject((String)this.taskRequest.getTaskParams(), OpenmldbParameters.class);
        log.info("Initialize openmldb task params {}", (Object)JSONUtils.toPrettyJsonString((Object)this.pythonParameters));
        if (this.pythonParameters == null || !this.pythonParameters.checkParameters()) {
            throw new TaskException("openmldb task params is not valid");
        }
    }

    protected String buildPythonCommandFilePath() {
        return String.format("%s/openmldb_%s.py", this.taskRequest.getExecutePath(), this.taskRequest.getTaskAppId());
    }

    protected String buildPythonScriptContent() {
        OpenmldbParameters openmldbParameters = (OpenmldbParameters)this.pythonParameters;
        log.info("raw sql script : {}", (Object)openmldbParameters.getSql());
        String rawSQLScript = openmldbParameters.getSql().replaceAll("[\\r]?\\n", "\n");
        Map paramsMap = this.mergeParamsWithContext((AbstractParameters)openmldbParameters);
        rawSQLScript = ParameterUtils.convertParameterPlaceholders((String)rawSQLScript, (Map)ParameterUtils.convert((Map)paramsMap));
        String pythonScript = this.buildPythonScriptsFromSql(rawSQLScript);
        log.info("rendered python script : {}", (Object)pythonScript);
        return pythonScript;
    }

    private String buildPythonScriptsFromSql(String rawSqlScript) {
        StringBuilder builder = new StringBuilder("import openmldb\nimport sqlalchemy as db\n");
        OpenmldbParameters openmldbParameters = (OpenmldbParameters)this.pythonParameters;
        builder.append(String.format("engine = db.create_engine('openmldb:///?zk=%s&zkPath=%s')\n", openmldbParameters.getZk(), openmldbParameters.getZkPath()));
        builder.append("con = engine.connect()\n");
        String executeMode = openmldbParameters.getExecuteMode().toLowerCase(Locale.ROOT);
        builder.append("con.execute(\"set @@execute_mode='").append(executeMode).append("';\")\n");
        if (executeMode.equals("offline")) {
            builder.append("con.execute(\"set @@sync_job=true\")\n");
            builder.append("con.execute(\"set @@job_timeout=1800000\")\n");
        }
        for (String sql : rawSqlScript.split(";")) {
            if (!SQL_PATTERN.matcher(sql).find()) continue;
            sql = sql.replaceAll("\\n", "\\\\n");
            builder.append("con.execute(\"").append(sql).append("\")\n");
        }
        return builder.toString();
    }

    protected String buildPythonExecuteCommand(String pythonFile) {
        Preconditions.checkNotNull((Object)pythonFile, (Object)"Python file cannot be null");
        return this.getPythonCommand() + " " + pythonFile;
    }

    private String getPythonCommand() {
        String pythonHome = System.getenv("PYTHON_LAUNCHER");
        return this.getPythonCommand(pythonHome);
    }

    private String getPythonCommand(String pythonHome) {
        if (StringUtils.isEmpty((CharSequence)pythonHome)) {
            return OPENMLDB_PYTHON;
        }
        String pythonBinPath = "/bin/python3";
        Matcher matcher = PYTHON_PATH_PATTERN.matcher(pythonHome);
        if (matcher.find()) {
            return matcher.replaceAll(pythonBinPath);
        }
        return Paths.get(pythonHome, pythonBinPath).toString();
    }
}

