/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.mr;

import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractYarnTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.mr.MapReduceArgsUtils;
import org.apache.dolphinscheduler.plugin.task.mr.MapReduceParameters;
import org.apache.dolphinscheduler.plugin.task.mr.ProgramType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapReduceTask
extends AbstractYarnTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MapReduceTask.class);
    private static final String MAPREDUCE_COMMAND = "hadoop";
    private MapReduceParameters mapreduceParameters;
    private final TaskExecutionContext taskExecutionContext;

    public MapReduceTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
    }

    public void init() {
        this.mapreduceParameters = (MapReduceParameters)((Object)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), MapReduceParameters.class));
        if (this.mapreduceParameters == null || !this.mapreduceParameters.checkParameters()) {
            throw new RuntimeException("mapreduce task params is not valid");
        }
        Map paramsMap = this.taskExecutionContext.getPrepareParamsMap();
        String args = ParameterUtils.convertParameterPlaceholders((String)this.mapreduceParameters.getMainArgs(), (Map)ParameterUtils.convert((Map)paramsMap));
        this.mapreduceParameters.setMainArgs(args);
        if (this.mapreduceParameters.getProgramType() != null && this.mapreduceParameters.getProgramType() == ProgramType.PYTHON) {
            String others = ParameterUtils.convertParameterPlaceholders((String)this.mapreduceParameters.getOthers(), (Map)ParameterUtils.convert((Map)paramsMap));
            this.mapreduceParameters.setOthers(others);
        }
        log.info("Initialize mapreduce task params {}", (Object)JSONUtils.toPrettyJsonString((Object)((Object)this.mapreduceParameters)));
    }

    protected String getScript() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(MAPREDUCE_COMMAND);
        args.addAll(MapReduceArgsUtils.buildArgs(this.mapreduceParameters, this.taskExecutionContext));
        return args.stream().collect(Collectors.joining(" "));
    }

    public AbstractParameters getParameters() {
        return this.mapreduceParameters;
    }
}

