/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.task.executor.container;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dolphinscheduler.task.executor.ITaskExecutor;
import org.apache.dolphinscheduler.task.executor.worker.ITaskExecutorWorker;

public class TaskExecutorAssignmentTable {
    private final Map<Integer, Integer> assignedTaskExecutorIdToWorkerIdMapping = new ConcurrentHashMap<Integer, Integer>();

    public void registerTaskExecutor(ITaskExecutor taskExecutor, ITaskExecutorWorker taskExecutorWorker) {
        this.assignedTaskExecutorIdToWorkerIdMapping.put(taskExecutor.getId(), taskExecutorWorker.getId());
    }

    public boolean isTaskExecutorRegistered(ITaskExecutor taskExecutor) {
        return this.assignedTaskExecutorIdToWorkerIdMapping.containsKey(taskExecutor.getId());
    }

    public void unregisterTaskExecutor(ITaskExecutor taskExecutor) {
        this.assignedTaskExecutorIdToWorkerIdMapping.remove(taskExecutor.getId());
    }

    public Integer getTaskExecutorWorkerId(ITaskExecutor taskExecutor) {
        return this.assignedTaskExecutorIdToWorkerIdMapping.get(taskExecutor.getId());
    }

    public boolean isEmpty() {
        return this.assignedTaskExecutorIdToWorkerIdMapping.isEmpty();
    }
}

